/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.api.book.Entry;
import org.jetbrains.annotations.Nullable;

public class BookContentImpl
implements BookContent {
    private final Map<String, BookContent.LocalisedBookContent> content;

    public BookContentImpl(Map<String, BookContent.LocalisedBookContent> content) {
        this.content = content;
    }

    @Override
    @Nullable
    public BookContent.LocalisedBookContent getContent(String language) {
        if (this.content.containsKey(language)) {
            return this.content.get(language);
        }
        if (this.content.containsKey("en_us")) {
            return this.content.get("en_us");
        }
        return this.content.values().stream().findFirst().orElse(null);
    }

    @Override
    public Collection<String> getLanguages() {
        return this.content.keySet();
    }

    public record LocalisedBookContentImpl(Map<String, Category> categories, Map<String, Entry> entries) implements BookContent.LocalisedBookContent
    {
        public static LocalisedBookContentImpl create() {
            return new LocalisedBookContentImpl(new HashMap<String, Category>(), new HashMap<String, Entry>());
        }

        @Override
        @Nullable
        public Category getCategory(String id) {
            return this.categories.get(id);
        }

        @Override
        public boolean hasCategory(String id) {
            return this.categories.containsKey(id);
        }

        @Override
        @Nullable
        public Entry getEntry(String id) {
            return this.entries.get(id);
        }

        @Override
        public boolean hasEntry(String id) {
            return this.entries.containsKey(id);
        }

        @Override
        public Collection<String> getCategoryIds() {
            return this.categories.keySet();
        }

        @Override
        public Collection<String> getEntryIds() {
            return this.entries.keySet();
        }
    }
}

