/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.common.book_types.ClassicBookType;
import net.favouriteless.modopedia.common.book_types.LockedViewType;
import net.favouriteless.modopedia.common.init.MSoundEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public class BookImpl
implements Book {
    public static final BookType DEFAULT_TYPE = new ClassicBookType(LockedViewType.HIDDEN, 37, 7, 10);
    public static final ResourceLocation DEFAULT_TEXTURE = Modopedia.id("brown_brass");
    public static final ResourceLocation DEFAULT_ITEM_MODEL = Modopedia.id("item/modopedia_books/brown_brass");
    public static final Holder<SoundEvent> DEFAULT_OPEN_SOUND = MSoundEvents.BOOK_OPEN;
    public static final Holder<SoundEvent> DEFAULT_FLIP_SOUND = MSoundEvents.BOOK_FLIP;
    public static final ResourceLocation DEFAULT_FONT = Modopedia.id("default");
    public static final int DEFAULT_TEXT_COLOUR = 0;
    public static final int DEFAULT_HEADER_COLOUR = 0;
    public static final int DEFAULT_LINE_WIDTH = 100;
    private final BookType type;
    private final String title;
    private final String subtitle;
    private final String rawLandingText;
    private final ResourceLocation texture;
    private final ResourceLocation itemModel;
    private final ResourceKey<CreativeModeTab> tab;
    private final Holder<SoundEvent> openSound;
    private final Holder<SoundEvent> flipSound;
    private final ResourceLocation font;
    private final int textColour;
    private final int headerColour;
    private final int lineWidth;
    public static final Codec<Book> PERSISTENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(Book::getTitle), (App)Codec.STRING.optionalFieldOf("subtitle").forGetter(b -> Optional.ofNullable(b.getSubtitle())), (App)BookType.codec().optionalFieldOf("type", (Object)DEFAULT_TYPE).forGetter(Book::getType), (App)Codec.STRING.optionalFieldOf("landing_text").forGetter(b -> Optional.ofNullable(b.getRawLandingText())), (App)ResourceLocation.CODEC.optionalFieldOf("texture", (Object)DEFAULT_TEXTURE).forGetter(Book::getTexture), (App)ResourceLocation.CODEC.optionalFieldOf("model", (Object)DEFAULT_ITEM_MODEL).forGetter(Book::getItemModelLocation), (App)ResourceKey.codec((ResourceKey)Registries.CREATIVE_MODE_TAB).optionalFieldOf("creative_tab").forGetter(b -> Optional.ofNullable(b.getCreativeTab())), (App)SoundEvent.CODEC.optionalFieldOf("open_sound", DEFAULT_OPEN_SOUND).forGetter(Book::getOpenSound), (App)SoundEvent.CODEC.optionalFieldOf("flip_sound", DEFAULT_FLIP_SOUND).forGetter(Book::getFlipSound), (App)ResourceLocation.CODEC.optionalFieldOf("font", (Object)DEFAULT_FONT).forGetter(Book::getFont), (App)Codec.STRING.optionalFieldOf("text_colour", (Object)Integer.toHexString(0)).forGetter(b -> Integer.toHexString(b.getTextColour())), (App)Codec.STRING.optionalFieldOf("header_colour", (Object)Integer.toHexString(0)).forGetter(b -> Integer.toHexString(b.getHeaderColour())), (App)Codec.INT.optionalFieldOf("line_width", (Object)100).forGetter(Book::getLineWidth)).apply((Applicative)instance, (title, subtitle, type, landingText, texture, model, tab, openSound, flipSound, font, textColour, headerColour, lineWidth) -> new BookImpl((String)title, subtitle.orElse(null), (BookType)type, landingText.orElse(null), (ResourceLocation)texture, (ResourceLocation)model, (ResourceKey<CreativeModeTab>)((ResourceKey)tab.orElse(null)), (Holder<SoundEvent>)openSound, (Holder<SoundEvent>)flipSound, (ResourceLocation)font, Integer.parseInt(textColour, 16), Integer.parseInt(headerColour, 16), (int)lineWidth)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Book> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Book>(){

        public Book decode(RegistryFriendlyByteBuf buf) {
            return new BookImpl((String)ByteBufCodecs.STRING_UTF8.decode((Object)buf), ((Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buf)).orElse(null), (BookType)ByteBufCodecs.fromCodec(BookType.codec()).decode((Object)buf), ((Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buf)).orElse(null), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf), (ResourceKey<CreativeModeTab>)((ResourceKey)((Optional)ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.CREATIVE_MODE_TAB)).decode((Object)buf)).orElse(null)), (Holder<SoundEvent>)((Holder)SoundEvent.STREAM_CODEC.decode((Object)buf)), (Holder<SoundEvent>)((Holder)SoundEvent.STREAM_CODEC.decode((Object)buf)), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf), (Integer)ByteBufCodecs.INT.decode((Object)buf), (Integer)ByteBufCodecs.INT.decode((Object)buf), (Integer)ByteBufCodecs.INT.decode((Object)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, Book book) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)book.getTitle());
            ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buf, Optional.ofNullable(book.getSubtitle()));
            ByteBufCodecs.fromCodec(BookType.codec()).encode((Object)buf, (Object)book.getType());
            ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buf, Optional.ofNullable(book.getRawLandingText()));
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)book.getTexture());
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)book.getItemModelLocation());
            ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.CREATIVE_MODE_TAB)).encode((Object)buf, Optional.ofNullable(book.getCreativeTab()));
            SoundEvent.STREAM_CODEC.encode((Object)buf, book.getOpenSound());
            SoundEvent.STREAM_CODEC.encode((Object)buf, book.getFlipSound());
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)book.getFont());
            ByteBufCodecs.INT.encode((Object)buf, (Object)book.getTextColour());
            ByteBufCodecs.INT.encode((Object)buf, (Object)book.getHeaderColour());
            ByteBufCodecs.INT.encode((Object)buf, (Object)book.getLineWidth());
        }
    };

    public BookImpl(String title, String subtitle, BookType type, String rawLandingText, ResourceLocation texture, ResourceLocation itemModel, ResourceKey<CreativeModeTab> tab, Holder<SoundEvent> openSound, Holder<SoundEvent> flipSound, ResourceLocation font, int textColour, int headerColour, int lineWidth) {
        this.type = type;
        this.title = title;
        this.subtitle = subtitle;
        this.rawLandingText = rawLandingText;
        this.texture = texture;
        this.itemModel = itemModel;
        this.tab = tab;
        this.openSound = openSound;
        this.flipSound = flipSound;
        this.font = font;
        this.textColour = textColour;
        this.headerColour = headerColour;
        this.lineWidth = lineWidth;
    }

    @Override
    public BookType getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getSubtitle() {
        return this.subtitle;
    }

    @Override
    @Nullable
    public String getRawLandingText() {
        return this.rawLandingText;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public ResourceLocation getItemModelLocation() {
        return this.itemModel;
    }

    @Override
    public Holder<SoundEvent> getOpenSound() {
        return this.openSound;
    }

    @Override
    public Holder<SoundEvent> getFlipSound() {
        return this.flipSound;
    }

    @Override
    public ResourceLocation getFont() {
        return this.font;
    }

    @Override
    public int getTextColour() {
        return this.textColour;
    }

    @Override
    public int getHeaderColour() {
        return this.headerColour;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public ResourceKey<CreativeModeTab> getCreativeTab() {
        return this.tab;
    }
}

