/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.google.common.reflect.TypeToken;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@Deprecated(since="1.1.0", forRemoval=true)
public class ItemPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("item");
    protected List<List<ItemStack>> items;
    protected int rowMax;
    protected int padding;
    protected boolean centered;
    protected boolean reverseY;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        this.items = lookup.get("items").asStream().map(v -> v.as(new TypeToken<List<ItemStack>>(){})).toList();
        if (this.items.isEmpty()) {
            throw new IllegalArgumentException("Item gallery cannot have zero items in it.");
        }
        this.rowMax = lookup.getOrDefault("row_max", Integer.MAX_VALUE).asInt();
        this.padding = lookup.getOrDefault("padding", 16).asInt();
        this.centered = lookup.getOrDefault("centered", false).asBoolean();
        this.reverseY = lookup.getOrDefault("reverse_y", false).asBoolean();
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, context, mouseX, mouseY, partialTick);
        int yOff = -this.padding;
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item;
            List<ItemStack> itemList;
            if (i % this.rowMax == 0) {
                yOff += this.padding;
            }
            if ((itemList = this.items.get(i)).isEmpty()) continue;
            int x = this.x + i % this.rowMax * this.padding;
            int y = this.y + (this.reverseY ? -yOff : yOff);
            int row = (i - 1 - i % this.rowMax) / this.rowMax;
            int rowWidth = (Math.min(this.rowMax, this.items.size() - row * this.rowMax) - 1) * this.padding + 16;
            if (this.centered) {
                x -= rowWidth / 2;
            }
            if ((item = itemList.get(context.getTicks() / 20 % itemList.size())).isEmpty()) continue;
            context.renderItem(graphics, item, x, y, mouseX, mouseY, this.entryId);
        }
    }
}

