/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import java.util.List;
import java.util.stream.Collectors;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TooltipPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("tooltip");
    protected List<Component> tooltipLines;
    protected int width;
    protected int height;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        this.width = lookup.get("width").asInt();
        this.height = lookup.get("height").asInt();
        this.tooltipLines = lookup.get("tooltip").asStream().map(var -> Component.translatable((String)var.asString())).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        if (context.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            graphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltipLines, mouseX, mouseY);
        }
    }
}

