/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import java.util.List;
import java.util.Objects;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.book.text.TextParser;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.CategoryScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.LandingScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.favouriteless.modopedia.common.book_types.LockedViewProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class PamphletLandingScreen<T extends BookType & LockedViewProvider>
extends CategoryScreen<T> {
    public static final int TITLE_COLOUR = 15722290;
    protected final Component subtitle;

    public PamphletLandingScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, Category category, BookScreen<?> lastScreen) {
        super(book, type, language, content, category, (Component)Component.translatable((String)book.getTitle()).withStyle(Style.EMPTY.withColor(15722290)), lastScreen);
        this.subtitle = book.getSubtitle() != null ? Component.translatable((String)book.getSubtitle()).withStyle(Style.EMPTY.withColor(15722290).withFont(Modopedia.id("default"))) : null;
    }

    @Override
    protected ScreenPage initFirstPage() {
        String rawLandingText = this.book.getRawLandingText();
        if (rawLandingText != null) {
            rawLandingText = Language.getInstance().getOrDefault(rawLandingText);
        }
        int lineWidth = this.texture.pages().getFirst().width();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        List<TextChunk> landingText = TextParser.parse(rawLandingText, this.getStyle(), lineWidth, lineHeight, this.language, Justify.LEFT);
        return new LandingScreenPage(this, this.title, this.subtitle, 37, 7, 10, landingText, 0, 0);
    }

    @Override
    protected boolean isTopLevel() {
        return true;
    }
}

