/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.common.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.favouriteless.modopedia.common.network.packets.client.OpenBookPayload;
import net.favouriteless.modopedia.common.network.packets.client.OpenCategoryPayload;
import net.favouriteless.modopedia.common.network.packets.client.OpenEntryPayload;
import net.favouriteless.modopedia.common.network.packets.client.ReloadBookContentPayload;
import net.favouriteless.modopedia.platform.CommonServices;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class MCommands {
    public static void load(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modopedia").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"open").then(Commands.literal((String)"book").then(Commands.argument((String)"book_id", (ArgumentType)ResourceLocationArgument.id()).executes(MCommands::openBook)))).then(((LiteralArgumentBuilder)Commands.literal((String)"category").then(Commands.argument((String)"book_id", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"category_id", (ArgumentType)StringArgumentType.string()).executes(ctx -> MCommands.openCategory((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"book_id")))))).then(Commands.argument((String)"category_id", (ArgumentType)StringArgumentType.string()).executes(ctx -> MCommands.openCategory((CommandContext<CommandSourceStack>)ctx, null))))).then(((LiteralArgumentBuilder)Commands.literal((String)"entry").then(Commands.argument((String)"book_id", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"entry_id", (ArgumentType)StringArgumentType.string()).executes(ctx -> MCommands.openEntry((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"book_id")))))).then(Commands.argument((String)"entry_id", (ArgumentType)StringArgumentType.string()).executes(ctx -> MCommands.openEntry((CommandContext<CommandSourceStack>)ctx, null)))))).then(Commands.literal((String)"reload").executes(MCommands::reloadContent)));
    }

    public static int reloadContent(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        CommonServices.NETWORK.sendToPlayer(new ReloadBookContentPayload(), player);
        return 1;
    }

    public static int openBook(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        CommonServices.NETWORK.sendToPlayer(new OpenBookPayload(ResourceLocationArgument.getId(context, (String)"book_id")), player);
        return 1;
    }

    public static int openCategory(CommandContext<CommandSourceStack> context, ResourceLocation id) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        CommonServices.NETWORK.sendToPlayer(new OpenCategoryPayload(Optional.ofNullable(id), StringArgumentType.getString(context, (String)"category_id")), player);
        return 1;
    }

    public static int openEntry(CommandContext<CommandSourceStack> context, ResourceLocation id) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        CommonServices.NETWORK.sendToPlayer(new OpenEntryPayload(Optional.ofNullable(id), StringArgumentType.getString(context, (String)"entry_id")), player);
        return 1;
    }
}

