/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.neoforge;

import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.common.CommonConfig;
import net.favouriteless.modopedia.common.CommonEvents;
import net.favouriteless.modopedia.common.ServerConfig;
import net.favouriteless.modopedia.common.network.packets.client.ClearBooksPayload;
import net.favouriteless.modopedia.common.network.packets.client.OpenBookPayload;
import net.favouriteless.modopedia.common.network.packets.client.OpenCategoryPayload;
import net.favouriteless.modopedia.common.network.packets.client.OpenEntryPayload;
import net.favouriteless.modopedia.common.network.packets.client.ReloadBookContentPayload;
import net.favouriteless.modopedia.common.network.packets.client.SyncBookPayload;
import net.favouriteless.modopedia.platform.services.NeoCommonRegistryHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="modopedia")
@EventBusSubscriber(modid="modopedia", bus=EventBusSubscriber.Bus.MOD)
public class ModopediaNeo {
    public ModopediaNeo(IEventBus bus, ModContainer container) {
        NeoCommonRegistryHelper.ITEM_REGISTRY.register(bus);
        NeoCommonRegistryHelper.DATA_COMPONENT_REGISTRY.register(bus);
        NeoCommonRegistryHelper.SOUND_EVENT_REGISTRY.register(bus);
        Modopedia.init();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "modopedia-common.toml");
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC, "modopedia-server.toml");
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(ClearBooksPayload.TYPE, ClearBooksPayload.STREAM_CODEC, (payload, context) -> payload.handle());
        registrar.playToClient(SyncBookPayload.TYPE, SyncBookPayload.STREAM_CODEC, (payload, context) -> payload.handle());
        registrar.playToClient(ReloadBookContentPayload.TYPE, ReloadBookContentPayload.STREAM_CODEC, (payload, context) -> payload.handle());
        registrar.playToClient(OpenBookPayload.TYPE, OpenBookPayload.STREAM_CODEC, (payload, context) -> payload.handle());
        registrar.playToClient(OpenCategoryPayload.TYPE, OpenCategoryPayload.STREAM_CODEC, (payload, context) -> payload.handle());
        registrar.playToClient(OpenEntryPayload.TYPE, OpenEntryPayload.STREAM_CODEC, (payload, context) -> payload.handle());
    }

    @SubscribeEvent
    public static void onTabContents(BuildCreativeModeTabContentsEvent event) {
        CommonEvents.onTabContents((ResourceKey<CreativeModeTab>)event.getTabKey(), i -> event.accept(i, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY));
    }
}

