/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.neoforge.client;

import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.client.ClientConfig;
import net.favouriteless.modopedia.client.MBookModel;
import net.favouriteless.modopedia.client.ModopediaClient;
import net.favouriteless.modopedia.client.init.MKeyMappings;
import net.favouriteless.modopedia.platform.services.NeoClientRegistryHelper;
import net.favouriteless.modopedia.util.client.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@Mod(value="modopedia", dist={Dist.CLIENT})
@EventBusSubscriber(modid="modopedia", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModopediaNeoClient {
    public ModopediaNeoClient(IEventBus bus, ModContainer container) {
        ModopediaClient.init();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "modopedia-client.toml");
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        for (PreparableReloadListener listener : NeoClientRegistryHelper.RELOAD_LISTENERS) {
            event.registerReloadListener(listener);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        ResourceUtils.getBookModels().map(ModelResourceLocation::standalone).forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @SubscribeEvent
    public static void modifyModels(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation key = ModelResourceLocation.inventory((ResourceLocation)Modopedia.id("book"));
        event.getModels().computeIfPresent(key, (k, original) -> new MBookModel((BakedModel)original, m -> Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)m))));
    }

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register(MKeyMappings.KEY_STUDY);
    }
}

