/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.network;

import dev.terminalmc.moremousetweaks.MoreMouseTweaks;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;

public class InteractionManager {
    public static final Waiter TICK_WAITER = type -> type == TriggerType.TICK;
    private static final Queue<InteractionEvent> eventQueue = new ArrayDeque<InteractionEvent>();
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private static ScheduledFuture<?> tickFuture;
    private static Waiter waiter;

    public static void pushClickEvent(int containerId, int slotId, int mouseButton, ClickType clickType) {
        InteractionManager.push(new ClickEvent(containerId, slotId, mouseButton, clickType, TICK_WAITER));
    }

    public static void pushCallbackEvent(Supplier<Waiter> callback) {
        InteractionManager.push(new CallbackEvent(callback));
    }

    public static void pushPacketEvent(Packet<?> packet, Waiter waiter) {
        InteractionManager.push(new PacketEvent(packet, waiter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void push(InteractionEvent event) {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            eventQueue.add(event);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            eventQueue.clear();
            waiter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerSend(TriggerType type) {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            if (waiter == null || waiter.trigger(type)) {
                do {
                    InteractionEvent event;
                    if ((event = eventQueue.poll()) == null) {
                        waiter = null;
                        break;
                    }
                    InteractionManager.doSendEvent(event);
                } while (waiter.trigger(TriggerType.INITIAL));
            }
        }
    }

    private static void doSendEvent(InteractionEvent event) {
        Waiter blockingWaiter;
        waiter = blockingWaiter = triggerType -> false;
        Minecraft.getInstance().execute(() -> {
            Queue<InteractionEvent> queue = eventQueue;
            synchronized (queue) {
                if (waiter == blockingWaiter) {
                    waiter = event.send();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWaiter(Waiter waiter) {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            InteractionManager.waiter = waiter;
        }
    }

    public static void setTickRate(long intervalMs) {
        if (tickFuture != null) {
            tickFuture.cancel(false);
        }
        tickFuture = executor.scheduleAtFixedRate(InteractionManager::tick, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
    }

    public static void tick() {
        try {
            InteractionManager.triggerSend(TriggerType.TICK);
        }
        catch (Exception e) {
            MoreMouseTweaks.LOG.error("Error while ticking InteractionManager", e);
        }
    }

    static {
        waiter = null;
    }

    public static class ClickEvent
    implements InteractionEvent {
        private final Waiter waiter;
        private final int containerId;
        private final int slotId;
        private final int mouseButton;
        private final ClickType clickType;

        public ClickEvent(int containerId, int slotId, int mouseButton, ClickType clickType, Waiter waiter) {
            this.containerId = containerId;
            this.slotId = slotId;
            this.mouseButton = mouseButton;
            this.clickType = clickType;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            Minecraft mc = Minecraft.getInstance();
            if (mc.gameMode == null) {
                MoreMouseTweaks.LOG.error("Unable to send click event: gameMode is null", new Object[0]);
            } else if (mc.player == null) {
                MoreMouseTweaks.LOG.error("Unable to send click event: player is null", new Object[0]);
            } else {
                mc.gameMode.handleInventoryMouseClick(this.containerId, this.slotId, this.mouseButton, this.clickType, (Player)mc.player);
            }
            return this.waiter;
        }
    }

    @FunctionalInterface
    public static interface Waiter {
        public boolean trigger(TriggerType var1);

        public static Waiter equal(TriggerType type) {
            return type::equals;
        }
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public Waiter send();
    }

    public static class CallbackEvent
    implements InteractionEvent {
        private final Supplier<Waiter> callback;

        public CallbackEvent(Supplier<Waiter> callback) {
            this.callback = callback;
        }

        @Override
        public Waiter send() {
            return this.callback.get();
        }
    }

    public static class PacketEvent
    implements InteractionEvent {
        private final Packet<?> packet;
        private final Waiter waiter;

        public PacketEvent(Packet<?> packet, Waiter waiter) {
            this.packet = packet;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null) {
                MoreMouseTweaks.LOG.error("Unable to send packet event: connection is null", new Object[0]);
            } else {
                connection.send(this.packet);
            }
            return this.waiter;
        }
    }

    public static enum TriggerType {
        INITIAL,
        CONTAINER_SLOT_UPDATE,
        HELD_ITEM_CHANGE,
        TICK;

    }
}

