/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.RigUtils;
import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.GeckoDynamicChain;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.data.EntityModelData;

public class ModelSculptor
extends MowzieGeoModel<EntitySculptor> {
    private GeckoDynamicChain tail;
    public MowzieGeoBone[] beardOriginal;
    public MowzieGeoBone[] beardDynamic;
    public MowzieGeoBone[] armOriginal;
    public MowzieGeoBone[] armDynamic;
    private static final String[] GAUNTLET_ASSEMBLE_ORDER = new String[]{"centerRock", "sleeve", "rightRock1", "wrist", "pinky", "index", "thumb", "leftRock1", "leftRock2", "rightRock2"};

    public ResourceLocation getModelResource(EntitySculptor object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geo/sculptor.geo.json");
    }

    public ResourceLocation getTextureResource(EntitySculptor object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/entity/sculptor.png");
    }

    public ResourceLocation getAnimationResource(EntitySculptor object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"animations/sculptor.animation.json");
    }

    public void setCustomAnimations(EntitySculptor entity, long instanceId, AnimationState<EntitySculptor> animationState) {
        GeoBone head = (GeoBone)this.getBone("head").get();
        GeoBone chestJoint = (GeoBone)this.getBone("chestJoint").get();
        GeoBone handClosedL = (GeoBone)this.getBone("handClosedLeft").get();
        GeoBone handClosedR = (GeoBone)this.getBone("handClosedRight").get();
        GeoBone handOpenL = (GeoBone)this.getBone("handOpenLeft").get();
        GeoBone handOpenR = (GeoBone)this.getBone("handOpenRight").get();
        GeoBone backCloth = (GeoBone)this.getBone("clothBack").get();
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        float torsoAimController = this.getControllerValue("torsoAimController");
        head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180) * (1.0f - torsoAimController));
        head.setRotY(head.getRotY() + entityData.netHeadYaw() * ((float)Math.PI / 180) * (1.0f - torsoAimController));
        chestJoint.setRotX(chestJoint.getRotX() + entityData.headPitch() * ((float)Math.PI / 180) * torsoAimController);
        chestJoint.setRotY(chestJoint.getRotY() + entityData.netHeadYaw() * ((float)Math.PI / 180) * torsoAimController);
        if (entity.isAlive()) {
            this.idleAnim(entity, animationState);
        }
        float handControllerLeft = this.getControllerValue("handControllerLeft");
        float handControllerRight = this.getControllerValue("handControllerRight");
        boolean handLOpen = handControllerLeft == 0.0f;
        boolean handROpen = handControllerRight == 0.0f;
        handClosedL.setHidden(handLOpen);
        handClosedR.setHidden(handROpen);
        handOpenL.setHidden(!handLOpen);
        handOpenR.setHidden(!handROpen);
        backCloth.setHidden(false);
        this.beadsCorrections(entity);
        this.skirtCorrections(entity);
        this.staffRendering(entity);
        this.gauntletVisibility();
        if (this.beardOriginal == null || this.beardDynamic == null) {
            this.beardOriginal = new MowzieGeoBone[]{this.getMowzieBone("beard3"), this.getMowzieBone("beard4"), this.getMowzieBone("beard5Rot"), this.getMowzieBone("beard6")};
            this.beardDynamic = new MowzieGeoBone[this.beardOriginal.length];
        }
        if (entity.beardChain != null) {
            entity.beardChain.setChainArrays(this.beardOriginal, this.beardDynamic);
        }
    }

    private void beadsCorrections(EntitySculptor entity) {
        HashMap<MowzieGeoBone, Vec3> beadsDirections = new HashMap<MowzieGeoBone, Vec3>();
        beadsDirections.put(this.getMowzieBone("bead1"), new Vec3(0.0, -1.0, 0.0));
        beadsDirections.put(this.getMowzieBone("bead2"), new Vec3(0.0, -1.0, 0.0));
        beadsDirections.put(this.getMowzieBone("bead3"), new Vec3(0.0, -1.0, 0.0));
        beadsDirections.put(this.getMowzieBone("bead4"), new Vec3(0.0, -0.5, 0.25));
        beadsDirections.put(this.getMowzieBone("bead5"), new Vec3(0.0, -0.5, 0.25));
        beadsDirections.put(this.getMowzieBone("bead6"), new Vec3(0.0, -0.5, 1.0));
        beadsDirections.put(this.getMowzieBone("bead7"), new Vec3(0.0, -0.5, 1.0));
        beadsDirections.put(this.getMowzieBone("bead8"), new Vec3(0.0, -0.25, 0.75));
        beadsDirections.put(this.getMowzieBone("bead9"), new Vec3(0.0, -0.25, 0.75));
        GeoBone headJoint = (GeoBone)this.getBone("headJoint").get();
        Vec3 headPos = new Vec3((double)headJoint.getPivotX(), (double)headJoint.getPivotY(), (double)headJoint.getPivotZ());
        GeoBone head = (GeoBone)this.getBone("head").get();
        Vec3 headDir = new Vec3(0.0, 0.0, -1.0).normalize();
        headDir = headDir.yRot(head.getRotY()).xRot(head.getRotX());
        for (Map.Entry beadDir : beadsDirections.entrySet()) {
            MowzieGeoBone bead = (MowzieGeoBone)((Object)beadDir.getKey());
            Vec3 beadPos = new Vec3((double)bead.getPivotX(), (double)bead.getPivotY(), (double)bead.getPivotZ());
            Vec3 dir = beadPos.subtract(headPos).normalize().multiply(1.0, -1.0, 1.0);
            double dot = dir.dot(headDir);
            dot = Math.pow(Math.max(dot, 0.0), 3.5);
            Vec3 moveDir = ((Vec3)beadDir.getValue()).normalize();
            bead.addPos(moveDir.scale(dot * 3.0));
        }
    }

    private void skirtCorrections(EntitySculptor entity) {
        if (entity.calfRPos == null || entity.calfLPos == null || entity.thighRPos == null || entity.thighLPos == null || entity.skirtEndRPos == null || entity.skirtEndLPos == null || entity.skirtLocFrontRPos == null || entity.skirtLocFrontLPos == null || entity.skirtLocBackRPos == null || entity.skirtLocBackLPos == null || entity.frontClothRot == null) {
            return;
        }
        MowzieGeoBone headJoint = this.getMowzieBone("headJoint");
        MowzieGeoBone thighR = this.getMowzieBone("thighRight");
        MowzieGeoBone thighJointR = this.getMowzieBone("thighJointRight");
        MowzieGeoBone thighJointL = this.getMowzieBone("thighJointLeft");
        MowzieGeoBone calfR = this.getMowzieBone("calfRight");
        MowzieGeoBone thighL = this.getMowzieBone("thighLeft");
        MowzieGeoBone calfL = this.getMowzieBone("calfLeft");
        MowzieGeoBone footR = this.getMowzieBone("footRight");
        MowzieGeoBone skirtBack = this.getMowzieBone("skirtBack");
        MowzieGeoBone skirtFront = this.getMowzieBone("skirtFront");
        MowzieGeoBone skirtL = this.getMowzieBone("skirtLeft");
        MowzieGeoBone skirtR = this.getMowzieBone("skirtRight");
        MowzieGeoBone skirtJointL = this.getMowzieBone("skirtJointLeft");
        MowzieGeoBone skirtJointR = this.getMowzieBone("skirtJointRight");
        MowzieGeoBone skirtJoint2L = this.getMowzieBone("skirtJoint2Left");
        MowzieGeoBone skirtJoint2R = this.getMowzieBone("skirtJoint2Right");
        MowzieGeoBone skirtEndR = this.getMowzieBone("skirtEndRight");
        MowzieGeoBone skirtEndL = this.getMowzieBone("skirtEndLeft");
        MowzieGeoBone skirtLocFrontR = this.getMowzieBone("skirtFrontLocRight");
        MowzieGeoBone skirtLocFrontL = this.getMowzieBone("skirtFrontLocLeft");
        MowzieGeoBone skirtLocBackR = this.getMowzieBone("skirtBackLocRight");
        MowzieGeoBone skirtLocBackL = this.getMowzieBone("skirtBackLocLeft");
        headJoint.setHidden(false);
        Vec3 thighToKneeR = ModelSculptor.Vec3(entity.calfRPos).subtract(ModelSculptor.Vec3(entity.thighRPos)).normalize();
        Vec3 thighToKneeL = ModelSculptor.Vec3(entity.calfLPos).subtract(ModelSculptor.Vec3(entity.thighLPos)).normalize();
        skirtEndL.addPos(-0.2f, -1.5f, 0.0f);
        skirtEndR.addPos(0.2f, -1.5f, 0.0f);
        Vec3 thighToSkirtEndR = ModelSculptor.Vec3(entity.skirtEndRPos).subtract(ModelSculptor.Vec3(entity.thighRPos)).normalize();
        Vec3 thighToSkirtEndL = ModelSculptor.Vec3(entity.skirtEndLPos).subtract(ModelSculptor.Vec3(entity.thighLPos)).normalize();
        float rightDot = (float)thighToKneeR.dot(new Vec3(0.0, -1.0, 0.0));
        rightDot = (float)Math.pow(Math.max(rightDot, 0.0f), 3.0);
        float leftDot = (float)thighToKneeL.dot(new Vec3(0.0, -1.0, 0.0));
        leftDot = (float)Math.pow(Math.max(leftDot, 0.0f), 3.0);
        skirtJointR.addPos(Math.max(-0.9f * rightDot, -0.7f), 0.0f, Math.max(-0.7f * rightDot, -0.5f));
        skirtJointL.addPos(-Math.max(-0.9f * leftDot, -0.7f), 0.0f, Math.max(-0.7f * leftDot, -0.5f));
        Quaternionf rightRot = RigUtils.betweenVectors(thighToSkirtEndR, thighToKneeR);
        Quaternionf leftRot = RigUtils.betweenVectors(thighToSkirtEndL, thighToKneeL);
        Matrix4f rightMat = new Matrix4f().rotate((Quaternionfc)rightRot);
        Matrix4f leftMat = new Matrix4f().rotate((Quaternionfc)leftRot);
        skirtJoint2R.setModelXformOverride(rightMat);
        skirtJoint2L.setModelXformOverride(leftMat);
        Vec3 average = thighToKneeL.add(thighToKneeR).scale(2.0).multiply(0.0, 1.0, 1.0).normalize();
        float angleAv = (float)Mth.atan2((double)average.y(), (double)average.z());
        skirtBack.setRotX(skirtBack.getRotX() - angleAv + 3.48f);
        skirtFront.setRotX(skirtFront.getRotX() - Math.min(angleAv, -2.0f) + 3.48f);
        Vec3 skirtFrontDiff = ModelSculptor.Vec3(entity.skirtLocFrontLPos).subtract(ModelSculptor.Vec3(entity.skirtLocFrontRPos));
        skirtFront.setScaleX(Math.max((float)((double)0.3f + (double)0.15f * skirtFrontDiff.length()), 0.4f));
        Vec3 skirtBackDiff = ModelSculptor.Vec3(entity.skirtLocBackLPos).subtract(ModelSculptor.Vec3(entity.skirtLocBackRPos));
        skirtBack.setScaleX((float)((double)0.15f + (double)0.1f * skirtBackDiff.length()));
        float angleF = (float)Mth.atan2((double)skirtFrontDiff.normalize().z(), (double)skirtFrontDiff.normalize().x());
        if ((double)angleF < 0.001 || (double)angleF > 3.141) {
            angleF = 0.0f;
        }
        skirtFront.setRotY(angleF * 0.6f);
        skirtFront.addPos(0.5f * (float)ModelSculptor.Vec3(entity.skirtLocFrontRPos).add(skirtFrontDiff.scale(0.5)).x(), 0.0f, 0.0f);
        float angleB = (float)Mth.atan2((double)skirtBackDiff.normalize().z(), (double)skirtBackDiff.normalize().x());
        skirtBack.setRotY(angleB * 0.5f);
        skirtBack.addPos(0.5f * (float)ModelSculptor.Vec3(entity.skirtLocBackRPos).add(skirtBackDiff.scale(0.5)).x(), 0.0f, 0.0f);
        float bothDots = (float)Math.pow(rightDot * leftDot, 1.0);
        float f = Math.min(1.0f, bothDots * 2.0f);
        skirtR.addRot(0.0f, Mth.clamp((float)angleF, (float)-0.5f, (float)0.5f) * (1.0f - f) - bothDots * 0.4f, 0.0f);
        skirtL.addRot(0.0f, Mth.clamp((float)angleF, (float)-0.5f, (float)0.5f) * (1.0f - f) + bothDots * 0.4f, 0.0f);
        MowzieGeoBone frontCloth = this.getMowzieBone("clothFront");
        MowzieGeoBone frontCloth2 = this.getMowzieBone("clothFront2");
        frontCloth.setRot(skirtFront.getRot());
        Matrix4f mat = entity.frontClothRot;
        mat.invert();
        frontCloth2.setModelXformOverride(mat);
    }

    private void staffRendering(EntitySculptor entity) {
        MowzieGeoBone itemHandLeft = this.getMowzieBone("itemHandLeft");
        MowzieGeoBone itemHandRight = this.getMowzieBone("itemHandRight");
        MowzieGeoBone backItem = this.getMowzieBone("backItem");
        itemHandLeft.setHidden(true);
        itemHandRight.setHidden(true);
        backItem.setHidden(true);
        MowzieGeoBone staffController = this.getMowzieBone("staffController");
        switch ((int)staffController.getPosX()) {
            case -1: {
                itemHandRight.setHidden(false);
                break;
            }
            case 0: {
                backItem.setHidden(false);
                break;
            }
            case 1: {
                itemHandLeft.setHidden(false);
            }
        }
        itemHandLeft.setScale(1.2f);
        itemHandRight.setScale(1.2f);
        backItem.setScale(1.2f);
    }

    private void idleAnim(EntitySculptor entity, AnimationState<?> animationState) {
        float frame = (float)entity.frame + animationState.getPartialTick();
        MowzieGeoBone eyebrowRight = this.getMowzieBone("eyebrowRight");
        MowzieGeoBone eyebrowLeft = this.getMowzieBone("eyebrowLeft");
        MowzieGeoBone clothFront2 = this.getMowzieBone("clothFront2");
        MowzieGeoBone clothBack = this.getMowzieBone("clothBack");
        MowzieGeoBone footLeft = this.getMowzieBone("footLeft");
        MowzieGeoBone calfLeft = this.getMowzieBone("calfLeft");
        MowzieGeoBone thighLeft = this.getMowzieBone("thighLeft");
        MowzieGeoBone headJoint = this.getMowzieBone("headJoint");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone footRight = this.getMowzieBone("footRight");
        MowzieGeoBone calfRight = this.getMowzieBone("calfRight");
        MowzieGeoBone thighRight = this.getMowzieBone("thighRight");
        MowzieGeoBone mouth = this.getMowzieBone("mouth");
        MowzieGeoBone handLeft = this.getMowzieBone("handLeft");
        MowzieGeoBone lowerArmLeft = this.getMowzieBone("lowerArmLeft");
        MowzieGeoBone shoulderLeft = this.getMowzieBone("shoulderLeft");
        MowzieGeoBone handRight = this.getMowzieBone("handRight");
        MowzieGeoBone lowerArmRight = this.getMowzieBone("lowerArmRight");
        MowzieGeoBone shoulderRight = this.getMowzieBone("shoulderRight");
        MowzieGeoBone body = this.getMowzieBone("body");
        float idleAnim = this.getControllerValue("idleAnimController");
        float idleAnimDisableArms = this.getControllerValueInverted("idleAnimDisableArmsController");
        float idleSpeed = 0.08f;
        eyebrowRight.addPosY(idleAnim * (float)(Math.sin((double)(frame * idleSpeed) + 0.4) * 0.1));
        eyebrowLeft.addPosY(idleAnim * (float)(Math.sin((double)(frame * idleSpeed) + 0.4) * 0.1));
        clothFront2.addRotX(idleAnim * (float)(Math.sin(frame * idleSpeed - 1.0f) * 0.05));
        clothBack.addRotX(idleAnim * (float)(-Math.sin(frame * idleSpeed - 1.0f) * 0.05));
        footLeft.addRotZ(idleAnim * (float)(-0.175 - Math.sin((double)(frame * idleSpeed) + 0.5) * 0.035));
        calfLeft.addRotZ(idleAnim * (float)(0.175 + Math.sin((double)(frame * idleSpeed) + 0.5) * 0.035));
        thighLeft.addRotZ(idleAnim * (float)(0.035 - Math.sin((double)(frame * idleSpeed) + 1.5) * 0.035));
        headJoint.addRotX(idleAnim * (float)(Math.sin((double)(frame * idleSpeed) + 1.5) * 0.017));
        chest.addRotX(idleAnim * (float)(-Math.sin((frame * idleSpeed + 1.0f) * idleSpeed) * 0.017));
        footRight.addRotY(-0.1309f);
        footRight.addRotZ(idleAnim * (float)(-0.35 + Math.sin((double)(frame * idleSpeed) + 0.5) * 0.035));
        calfRight.addRotZ(idleAnim * (float)(0.567 - Math.sin((double)(frame * idleSpeed) + 0.5) * 0.035));
        thighRight.addRotZ(idleAnim * (float)(-0.297 + Math.sin((double)(frame * idleSpeed) + 1.5) * 0.035));
        mouth.addPosY(idleAnim * (float)(-Math.sin((double)(frame * idleSpeed) + 0.5) * (double)0.1f));
        mouth.setScaleY((float)((double)mouth.getScaleZ() + (double)idleAnim * Math.sin((double)(frame * idleSpeed) + 0.5) * (double)0.05f));
        handLeft.addRotY(idleAnim * idleAnimDisableArms * (float)(-Math.sin(frame * idleSpeed + 1.0f) * 0.05));
        lowerArmLeft.addRotX(idleAnim * idleAnimDisableArms * (float)(-Math.sin((double)(frame * idleSpeed) + 0.5) * 0.05));
        lowerArmLeft.addRotY(idleAnim * idleAnimDisableArms * (float)(-Math.sin((double)(frame * idleSpeed) + 0.5) * 0.05));
        shoulderLeft.addRotZ(idleAnim * idleAnimDisableArms * (float)(Math.sin((double)(frame * idleSpeed) - 0.5) * 0.05));
        handRight.addRotY(idleAnim * idleAnimDisableArms * (float)(Math.sin(frame * idleSpeed + 1.0f) * 0.05));
        lowerArmRight.addRotX(idleAnim * idleAnimDisableArms * (float)(-Math.sin((double)(frame * idleSpeed) + 0.5) * 0.05));
        lowerArmRight.addRotY(idleAnim * idleAnimDisableArms * (float)(Math.sin((double)(frame * idleSpeed) + 0.5) * 0.05));
        shoulderRight.addRotZ(idleAnim * idleAnimDisableArms * (float)(-Math.sin((double)(frame * idleSpeed) - 0.5) * 0.05));
        body.addRotX(idleAnim * (float)(-Math.cos((double)(frame * idleSpeed) + 0.5) * 0.017));
        body.addPosY(idleAnim * (float)(Math.sin(frame * idleSpeed) * 1.0));
    }

    private void gauntletVisibility() {
        float gauntletProgress = this.getControllerValue("gauntletProgressController");
        MowzieGeoBone gauntlet = this.getMowzieBone("gauntlet");
        MowzieGeoBone gauntletUnparented = this.getMowzieBone("gauntletUnparented");
        if ((double)gauntletProgress <= 0.0 || (double)gauntletProgress > 1.15) {
            gauntlet.setHidden(true);
            gauntletUnparented.setHidden(true);
        } else {
            gauntlet.setHidden(false);
            gauntletUnparented.setHidden(false);
            for (int i = 0; i < GAUNTLET_ASSEMBLE_ORDER.length; ++i) {
                String boneName = GAUNTLET_ASSEMBLE_ORDER[i];
                Optional bone = this.getBone(boneName);
                float waitForControllerValue = (float)i / (float)GAUNTLET_ASSEMBLE_ORDER.length + 0.2f;
                if (bone.isPresent()) {
                    ((GeoBone)bone.get()).setHidden(gauntletProgress < waitForControllerValue);
                } else {
                    System.out.println("Missing bone " + boneName);
                }
                Optional boneUnparented = this.getBone(boneName + "Unparented");
                if (boneUnparented.isPresent()) {
                    ((GeoBone)boneUnparented.get()).setHidden(gauntletProgress >= waitForControllerValue || (double)gauntletProgress < (double)waitForControllerValue - 0.1);
                    continue;
                }
                System.out.println("Missing bone " + boneName + "Unparented");
            }
        }
    }

    private static Vec3 Vec3(Vector3d vec) {
        return new Vec3(vec.x, vec.y, vec.z);
    }
}

