/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.types.AdvancedParticleType;
import com.bobmowzie.mowziesmobs.client.particle.types.DecalParticleType;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.OptionalDouble;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleDecal
extends AdvancedParticleBase {
    protected int spriteSize = 8;
    protected int bufferSize = 32;
    private final SpriteSet sprites;

    protected ParticleDecal(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, SpriteSet sprites, ParticleComponent[] components) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, rotation, scale, r, g, b, a, drag, duration, emissive, sprites, 8, 32, components);
    }

    protected ParticleDecal(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, SpriteSet sprites, int spriteSize, int bufferSize, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, rotation, scale, r, g, b, a, drag, duration, emissive, false, components);
        this.spriteSize = spriteSize;
        this.bufferSize = bufferSize;
        this.setSpriteFromAge(sprites);
        this.sprites = sprites;
    }

    private static OptionalDouble max(double ... v) {
        return Arrays.stream(v).max();
    }

    @Override
    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        this.alpha = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.alpha < 0.01) {
            this.alpha = 0.01f;
        }
        this.rCol = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.gCol = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.bCol = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.particleScale = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        if (!this.doRender) {
            return;
        }
        this.setSprite(this.sprites.get(Math.min(this.age, 5), 5));
        float decalRot = 0.0f;
        if (this.rotation instanceof ParticleRotation.EulerAngles) {
            float rotY;
            ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)this.rotation;
            decalRot = rotY = eulerRot.prevYaw + (eulerRot.yaw - eulerRot.prevYaw) * partialTicks;
        } else {
            ParticleRotation eulerRot = this.rotation;
            if (eulerRot instanceof ParticleRotation.FaceCamera) {
                float rotY;
                ParticleRotation.FaceCamera faceCamera = (ParticleRotation.FaceCamera)eulerRot;
                decalRot = rotY = faceCamera.prevAngle + (faceCamera.angle - faceCamera.prevAngle) * partialTicks;
            }
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int lightColor = this.getLightColor(partialTicks);
        float spriteScale = (float)this.spriteSize / (float)this.bufferSize;
        Vec3 corner0 = new Vec3((double)(-this.particleScale / 2.0f), 0.0, (double)(-this.particleScale / 2.0f)).yRot(decalRot);
        Vec3 corner1 = new Vec3((double)(this.particleScale / 2.0f), 0.0, (double)(this.particleScale / 2.0f)).yRot(decalRot);
        double extent = ParticleDecal.max(corner0.x(), corner1.x(), corner0.z(), corner1.z()).orElse(1.0);
        Vec3 minCorner = new Vec3(-extent, (double)(-this.particleScale), -extent).add(this.x, this.y, this.z);
        Vec3 maxCorner = new Vec3(extent, (double)this.particleScale, extent).add(this.x, this.y, this.z);
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)BlockPos.containing((Position)minCorner), (BlockPos)BlockPos.containing((Position)maxCorner))) {
            ParticleDecal.renderBlockDecal(buffer, renderInfo, (LevelReader)this.level, blockpos, this.x, this.y, this.z, u0, u1, v0, v1, this.particleScale, spriteScale, this.alpha, decalRot, this.rCol, this.gCol, this.bCol, lightColor);
        }
        for (ParticleComponent component : this.components) {
            component.postRender(this, buffer, renderInfo, partialTicks, lightColor);
        }
    }

    private static Vec2 rotateVec2(Vec2 v, float angle) {
        return new Vec2(v.x * (float)Math.cos(angle) - v.y * (float)Math.sin(angle), v.x * (float)Math.sin(angle) + v.y * (float)Math.cos(angle));
    }

    private static void renderBlockDecal(VertexConsumer buffer, Camera renderInfo, LevelReader level, BlockPos blockPos, double x, double y, double z, float u0, float u1, float v0, float v1, float scale, float spriteScale, float alpha, float rotation, float r, float g, float b, int lightColor) {
        float f;
        VoxelShape voxelshape;
        Vec2 center = new Vec2((float)x, (float)z);
        BlockPos blockpos = blockPos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE && blockstate.isCollisionShapeFullBlock((BlockGetter)level, blockpos) && !(voxelshape = blockstate.getShape((BlockGetter)level, blockPos.below())).isEmpty() && (f = alpha) >= 0.0f) {
            Vec2[] corners;
            if (f > 1.0f) {
                f = 1.0f;
            }
            double rad2 = Math.sqrt(2.0);
            double minX = x - (double)(scale * spriteScale) * rad2;
            double minZ = z - (double)(scale * spriteScale) * rad2;
            double maxX = x + (double)(scale * spriteScale) * rad2;
            double maxZ = z + (double)(scale * spriteScale) * rad2;
            AABB aabb = voxelshape.bounds();
            float d0 = (float)blockPos.getX() + (float)aabb.minX;
            float d1 = (float)blockPos.getX() + (float)aabb.maxX;
            float d2 = (float)blockPos.getY() + (float)aabb.minY + 0.005625f;
            float d3 = (float)blockPos.getZ() + (float)aabb.minZ;
            float d4 = (float)blockPos.getZ() + (float)aabb.maxZ;
            if ((double)d0 < minX) {
                d0 = (float)minX;
            }
            if ((double)d1 > maxX) {
                d1 = (float)maxX;
            }
            if ((double)d3 < minZ) {
                d3 = (float)minZ;
            }
            if ((double)d4 > maxZ) {
                d4 = (float)maxZ;
            }
            for (Vec2 corner : corners = new Vec2[]{new Vec2(d0, d3), new Vec2(d1, d3), new Vec2(d1, d4), new Vec2(d0, d4)}) {
                Vec2 cornerRelative = ParticleDecal.rotateVec2(corner.add(center.negated()), -rotation);
                Vec2 uv = new Vec2((cornerRelative.x / (2.0f * scale) + 0.5f) * (u1 - u0) + u0, (cornerRelative.y / (2.0f * scale) + 0.5f) * (v1 - v0) + v0);
                ParticleDecal.decalVertex(buffer, renderInfo, f, corner.x, d2, corner.y, uv.x, uv.y, r, g, b, lightColor);
            }
        }
    }

    private static void decalVertex(VertexConsumer buffer, Camera renderInfo, float alpha, float x, float y, float z, float u, float v, float r, float g, float b, int lightColor) {
        Vec3 vector3d = renderInfo.getPosition();
        buffer.addVertex((float)((double)x - vector3d.x()), (float)((double)y - vector3d.y()), (float)((double)z - vector3d.z())).setUv(u, v).setColor(r, g, b, alpha).setLight(lightColor);
    }

    public static void spawnDecal(Level world, Holder<ParticleType<?>> particle, double x, double y, double z, double motionX, double motionY, double motionZ, double angle, double scale, double red, double green, double blue, double alpha, double airDrag, double duration, boolean emissive, int spriteSize, int bufferSize, ParticleComponent[] components) {
        AdvancedParticleType base = new AdvancedParticleType(particle, new ParticleRotation.FaceCamera((float)angle), components, (float)red, (float)green, (float)blue, (float)alpha, (float)scale, (float)duration, (float)airDrag, emissive, false);
        world.addParticle((ParticleOptions)new DecalParticleType(base, spriteSize, bufferSize), x, y, z, motionX, motionY, motionZ);
    }

    public static class Provider
    implements ParticleProvider<DecalParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(DecalParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleDecal particle = new ParticleDecal(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.rotation(), typeIn.scale(), typeIn.red(), typeIn.green(), typeIn.blue(), typeIn.alpha(), typeIn.airDrag(), typeIn.duration(), typeIn.emissive(), this.spriteSet, typeIn.spriteSize(), typeIn.bufferSize(), typeIn.components());
            particle.setColor(typeIn.red(), typeIn.green(), typeIn.blue());
            return particle;
        }
    }
}

