/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRibbon;
import com.bobmowzie.mowziesmobs.client.particle.types.AdvancedParticleType;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class AdvancedParticleBase
extends TextureSheetParticle {
    public boolean doRender;
    public float airDrag;
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public float prevRed;
    public float prevGreen;
    public float prevBlue;
    public float prevAlpha;
    public float scale;
    public float prevScale;
    public float particleScale;
    public ParticleRotation rotation;
    public boolean emissive;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public ParticleRenderType renderType = MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    public ParticleComponent[] components;
    public ParticleRibbon ribbon;

    protected AdvancedParticleBase(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
        this.scale = (float)scale;
        this.lifetime = (int)duration;
        this.airDrag = (float)drag;
        this.rotation = rotation;
        this.components = components;
        this.emissive = emissive;
        this.ribbon = null;
        this.doRender = true;
        for (ParticleComponent component : components) {
            component.init(this);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.rotation.setPrevValues();
        this.prevScale = this.scale;
        this.hasPhysics = canCollide;
        this.gravity = 0.0f;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.renderType;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        super.setSprite(sprite);
    }

    public int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        if (this.emissive) {
            int k = i >> 16 & 0xFF;
            return 0xF0 | k << 16;
        }
        return i;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    public void tick() {
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.prevScale = this.scale;
        this.rotation.setPrevValues();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.prevMotionX = this.xd;
        this.prevMotionY = this.yd;
        this.prevMotionZ = this.zd;
        for (ParticleComponent component : this.components) {
            component.preUpdate(this);
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.updatePosition();
        for (ParticleComponent component : this.components) {
            component.postUpdate(this);
        }
        if (this.ribbon != null) {
            this.ribbon.setPos(this.x, this.y, this.z);
            this.ribbon.positions[0] = new Vec3(this.x, this.y, this.z);
            this.ribbon.prevPositions[0] = this.getPrevPos();
        }
    }

    protected void updatePosition() {
        this.yd -= 0.04 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        if (this.onGround && this.hasPhysics) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
        this.xd *= (double)this.airDrag;
        this.yd *= (double)this.airDrag;
        this.zd *= (double)this.airDrag;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        ParticleRotation eulerRot;
        this.alpha = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.alpha < 0.01) {
            this.alpha = 0.01f;
        }
        this.rCol = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.gCol = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.bCol = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.particleScale = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        if (!this.doRender) {
            return;
        }
        Vec3 Vector3d2 = renderInfo.getPosition();
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - Vector3d2.x());
        float f1 = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - Vector3d2.y());
        float f2 = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - Vector3d2.z());
        Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        ParticleRotation particleRotation = this.rotation;
        if (particleRotation instanceof ParticleRotation.FaceCamera) {
            ParticleRotation.FaceCamera faceCameraRot = (ParticleRotation.FaceCamera)particleRotation;
            if (faceCameraRot.angle == 0.0f && faceCameraRot.prevAngle == 0.0f) {
                quaternion = renderInfo.rotation();
            } else {
                quaternion = new Quaternionf((Quaternionfc)renderInfo.rotation());
                float f3 = Mth.lerp((float)partialTicks, (float)faceCameraRot.prevAngle, (float)faceCameraRot.angle);
                quaternion.mul((Quaternionfc)Axis.ZP.rotation(f3));
            }
        } else {
            ParticleRotation f3 = this.rotation;
            if (f3 instanceof ParticleRotation.EulerAngles) {
                eulerRot = (ParticleRotation.EulerAngles)f3;
                float rotX = eulerRot.prevPitch + (eulerRot.pitch - eulerRot.prevPitch) * partialTicks;
                float rotY = eulerRot.prevYaw + (eulerRot.yaw - eulerRot.prevYaw) * partialTicks;
                float rotZ = eulerRot.prevRoll + (eulerRot.roll - eulerRot.prevRoll) * partialTicks;
                Quaternionf quatX = MathUtils.quatFromRotationXYZ(rotX, 0.0f, 0.0f, false);
                Quaternionf quatY = MathUtils.quatFromRotationXYZ(0.0f, rotY, 0.0f, false);
                Quaternionf quatZ = MathUtils.quatFromRotationXYZ(0.0f, 0.0f, rotZ, false);
                quaternion.mul((Quaternionfc)quatZ);
                quaternion.mul((Quaternionfc)quatY);
                quaternion.mul((Quaternionfc)quatX);
            }
        }
        eulerRot = this.rotation;
        if (eulerRot instanceof ParticleRotation.OrientVector) {
            ParticleRotation.OrientVector orientRot = (ParticleRotation.OrientVector)eulerRot;
            double x = orientRot.prevOrientation.x + (orientRot.orientation.x - orientRot.prevOrientation.x) * (double)partialTicks;
            double y = orientRot.prevOrientation.y + (orientRot.orientation.y - orientRot.prevOrientation.y) * (double)partialTicks;
            double z = orientRot.prevOrientation.z + (orientRot.orientation.z - orientRot.prevOrientation.z) * (double)partialTicks;
            float pitch = (float)Math.asin(-y);
            float yaw = (float)Mth.atan2((double)x, (double)z);
            Quaternionf quatX = MathUtils.quatFromRotationXYZ(pitch, 0.0f, 0.0f, false);
            Quaternionf quatY = MathUtils.quatFromRotationXYZ(0.0f, yaw, 0.0f, false);
            quaternion.mul((Quaternionfc)quatY);
            quaternion.mul((Quaternionfc)quatX);
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.particleScale * 0.1f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            quaternion.transform(vector3f);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        int j = this.getLightColor(partialTicks);
        buffer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        for (ParticleComponent component : this.components) {
            component.postRender(this, buffer, renderInfo, partialTicks, j);
        }
    }

    public float getAge() {
        return this.age;
    }

    public double getPosX() {
        return this.x;
    }

    public void setPosX(double posX) {
        this.setPos(posX, this.y, this.z);
    }

    public double getPosY() {
        return this.y;
    }

    public void setPosY(double posY) {
        this.setPos(this.x, posY, this.z);
    }

    public double getPosZ() {
        return this.z;
    }

    public void setPosZ(double posZ) {
        this.setPos(this.x, this.y, posZ);
    }

    public double getMotionX() {
        return this.xd;
    }

    public void setMotionX(double motionX) {
        this.xd = motionX;
    }

    public double getMotionY() {
        return this.yd;
    }

    public void setMotionY(double motionY) {
        this.yd = motionY;
    }

    public double getMotionZ() {
        return this.zd;
    }

    public void setMotionZ(double motionZ) {
        this.zd = motionZ;
    }

    public Vec3 getPrevPos() {
        return new Vec3(this.xo, this.yo, this.zo);
    }

    public double getPrevPosX() {
        return this.xo;
    }

    public double getPrevPosY() {
        return this.yo;
    }

    public double getPrevPosZ() {
        return this.zo;
    }

    public static void spawnParticle(Level world, Holder<ParticleType<?>> particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, boolean canCollide) {
        AdvancedParticleBase.spawnParticle(world, particle, x, y, z, motionX, motionY, motionZ, faceCamera, yaw, pitch, roll, faceCameraAngle, scale, r, g, b, a, drag, duration, emissive, canCollide, new ParticleComponent[0]);
    }

    public static void spawnParticle(Level world, Holder<ParticleType<?>> particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double red, double green, double blue, double alpha, double airDrag, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components) {
        ParticleRotation rotation = faceCamera ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll);
        world.addParticle((ParticleOptions)new AdvancedParticleType(particle, rotation, components, (float)red, (float)green, (float)blue, (float)alpha, (float)scale, (float)duration, (float)airDrag, emissive, canCollide), x, y, z, motionX, motionY, motionZ);
    }

    public static void spawnParticle(Level world, Holder<ParticleType<?>> particle, double x, double y, double z, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double red, double green, double blue, double alpha, double airDrag, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components) {
        world.addParticle((ParticleOptions)new AdvancedParticleType(particle, rotation, components, (float)red, (float)green, (float)blue, (float)alpha, (float)scale, (float)duration, (float)airDrag, emissive, canCollide), x, y, z, motionX, motionY, motionZ);
    }

    public static void spawnAlwaysVisibleParticle(Level world, Holder<ParticleType<?>> particle, double distanceLimit, double x, double y, double z, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double red, double green, double blue, double alpha, double airDrag, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        boolean overrideLimiter = camera.getPosition().distanceToSqr(x, y, z) < distanceLimit * distanceLimit;
        world.addAlwaysVisibleParticle((ParticleOptions)new AdvancedParticleType(particle, rotation, components, (float)red, (float)green, (float)blue, (float)alpha, (float)scale, (float)duration, (float)airDrag, emissive, canCollide), overrideLimiter, x, y, z, motionX, motionY, motionZ);
    }

    public static void spawnAlwaysVisibleParticle(Level world, Holder<ParticleType<?>> particle, double distanceLimit, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double red, double green, double blue, double alpha, double airDrag, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        boolean overrideLimiter = camera.getPosition().distanceToSqr(x, y, z) < distanceLimit * distanceLimit;
        ParticleRotation rotation = faceCamera ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll);
        world.addAlwaysVisibleParticle((ParticleOptions)new AdvancedParticleType(particle, rotation, components, (float)red, (float)green, (float)blue, (float)alpha, (float)scale, (float)duration, (float)airDrag, emissive, canCollide), overrideLimiter, x, y, z, motionX, motionY, motionZ);
    }

    public static class Factory
    implements ParticleProvider<AdvancedParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(AdvancedParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AdvancedParticleBase particle = new AdvancedParticleBase(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.rotation(), typeIn.scale(), typeIn.red(), typeIn.green(), typeIn.blue(), typeIn.alpha(), typeIn.airDrag(), typeIn.duration(), typeIn.emissive(), typeIn.canCollide(), typeIn.components());
            particle.setColor(typeIn.red(), typeIn.green(), typeIn.blue());
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

