/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.sound;

import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicSound;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;

public class SculptorBossMusic
extends BossMusic<EntitySculptor> {
    protected static SoundEvent soundEventIntro = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_INTRO.get();
    protected static SoundEvent soundEventLevel1_1 = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_LEVEL1_1.get();
    protected static SoundEvent soundEventLevel1_2 = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_LEVEL1_2.get();
    protected static SoundEvent soundEventLevel2_1 = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_LEVEL2_1.get();
    protected static SoundEvent soundEventLevel2_2 = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_LEVEL2_2.get();
    protected static SoundEvent soundEventTransition = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_TRANSITION.get();
    protected static SoundEvent soundEventLevel3_1 = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_LEVEL3_1.get();
    protected static SoundEvent soundEventLevel3_2 = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_LEVEL3_2.get();
    protected static SoundEvent soundEventEnding = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_ENDING.get();
    protected static SoundEvent soundEventOutro = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_OUTRO.get();
    protected static SoundEvent soundEventCombat = (SoundEvent)MMSounds.MUSIC_SCULPTOR_THEME_COMBAT.get();
    protected BossMusicSound soundIntro;
    protected BossMusicSound soundTransition;
    protected BossMusicSound soundEnding;
    protected BossMusicSound soundOutro;
    protected BossMusicSound currentSound;
    private int ticksInSection;
    private static final SortedMap<SculptorMusicSection, Float> SECTION_HEIGHTS = new TreeMap<SculptorMusicSection, Float>();
    private static final Map<SculptorMusicSection, SoundEvent> SECTION_SOUNDS;
    private SculptorMusicSection currentSection;

    public SculptorBossMusic() {
        super(null);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ticksInSection;
        if (this.getBoss() != null) {
            if (this.currentSection == SculptorMusicSection.INTRO && this.ticksInSection == 35) {
                this.startMainTrack();
                return;
            }
            if (this.currentSection == SculptorMusicSection.TRANSITION && this.ticksInSection == 512) {
                if (((EntitySculptor)this.getBoss()).playerProgress() > ((Float)SECTION_HEIGHTS.get((Object)SculptorMusicSection.LEVEL3_2)).floatValue()) {
                    this.changeLevelSection(SculptorMusicSection.LEVEL3_2);
                    return;
                }
                if (((EntitySculptor)this.getBoss()).playerProgress() > ((Float)SECTION_HEIGHTS.get((Object)SculptorMusicSection.LEVEL3_1)).floatValue()) {
                    this.changeLevelSection(SculptorMusicSection.LEVEL3_1);
                    return;
                }
            }
            if (this.currentSection == SculptorMusicSection.ENDING && this.ticksInSection % 64 == 0 && ((EntitySculptor)this.getBoss()).isTestPassed()) {
                this.changeLevelSection(SculptorMusicSection.OUTRO, false);
                return;
            }
            if ((this.currentSection == SculptorMusicSection.LEVEL1_1 || this.currentSection == SculptorMusicSection.LEVEL1_2 || this.currentSection == SculptorMusicSection.LEVEL2_1 || this.currentSection == SculptorMusicSection.LEVEL2_2 || this.currentSection == SculptorMusicSection.TRANSITION || this.currentSection == SculptorMusicSection.LEVEL3_1 || this.currentSection == SculptorMusicSection.LEVEL3_2 || this.currentSection == SculptorMusicSection.ENDING) && this.ticksInSection % 128 == 0) {
                this.measureBreak();
            }
            if (this.currentSection != SculptorMusicSection.COMBAT && this.ticksInSection % 128 == 0 && ((EntitySculptor)this.getBoss()).isFighting()) {
                this.changeLevelSection(SculptorMusicSection.COMBAT);
            }
        }
    }

    private void startMainTrack() {
        this.ticksInSection = 0;
        if (this.getBoss() != null && ((EntitySculptor)this.getBoss()).isFighting()) {
            this.changeLevelSection(SculptorMusicSection.COMBAT);
        } else {
            this.changeLevelSection(SculptorMusicSection.LEVEL1_1);
        }
    }

    private void measureBreak() {
        if (((EntitySculptor)this.getBoss()).isTestPassed()) {
            this.changeLevelSection(SculptorMusicSection.OUTRO, false);
            return;
        }
        SculptorMusicSection currentSectionIgnoreTransition = this.currentSection;
        if (this.currentSection == SculptorMusicSection.TRANSITION) {
            currentSectionIgnoreTransition = SculptorMusicSection.LEVEL3_1;
        }
        float playerProgress = ((EntitySculptor)this.getBoss()).playerProgress();
        float currentSectionHeight = ((Float)SECTION_HEIGHTS.get((Object)currentSectionIgnoreTransition)).floatValue();
        SculptorMusicSection nextSection = SculptorMusicSection.LEVEL1_1;
        for (Map.Entry<SculptorMusicSection, Float> sectionHeight : SECTION_HEIGHTS.entrySet()) {
            SculptorMusicSection section = sectionHeight.getKey();
            float height = sectionHeight.getValue().floatValue();
            if (currentSectionHeight >= height) {
                height = (float)((double)height - 0.05);
            }
            if (!(playerProgress > height)) continue;
            nextSection = section;
        }
        if (nextSection != currentSectionIgnoreTransition) {
            if (!(currentSectionIgnoreTransition.isHigherThan(SculptorMusicSection.TRANSITION) || nextSection != SculptorMusicSection.LEVEL3_1 && nextSection != SculptorMusicSection.LEVEL3_2)) {
                nextSection = SculptorMusicSection.TRANSITION;
            }
            this.changeLevelSection(nextSection);
        }
    }

    private void changeLevelSection(SculptorMusicSection section) {
        this.changeLevelSection(section, true);
    }

    private void changeLevelSection(SculptorMusicSection section, boolean loop) {
        if (this.currentSound != null) {
            this.currentSound.fadeOut();
        }
        SoundEvent requestedSoundEvent = SECTION_SOUNDS.get((Object)section);
        this.currentSound = new BossMusicSound(requestedSoundEvent, (MowzieEntity)this.getBoss(), this, loop);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)this.currentSound);
        this.currentSection = section;
        this.ticksInSection = 0;
    }

    @Override
    public void play() {
        super.play();
        this.currentSection = SculptorMusicSection.INTRO;
        this.soundIntro = new BossMusicSound(soundEventIntro, (MowzieEntity)this.getBoss(), this, false);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundIntro);
        this.ticksInSection = 0;
    }

    @Override
    public void stop() {
        if (this.soundIntro != null) {
            this.soundIntro.doStop();
        }
        if (this.soundTransition != null) {
            this.soundTransition.doStop();
        }
        if (this.soundEnding != null) {
            this.soundEnding.doStop();
        }
        if (this.soundOutro != null) {
            this.soundOutro.doStop();
        }
        if (this.currentSound != null) {
            this.currentSound.doStop();
        }
        super.stop();
    }

    static {
        SECTION_HEIGHTS.put(SculptorMusicSection.LEVEL1_1, Float.valueOf(0.0f));
        SECTION_HEIGHTS.put(SculptorMusicSection.LEVEL1_2, Float.valueOf(0.1f));
        SECTION_HEIGHTS.put(SculptorMusicSection.LEVEL2_1, Float.valueOf(0.35f));
        SECTION_HEIGHTS.put(SculptorMusicSection.LEVEL2_2, Float.valueOf(0.5f));
        SECTION_HEIGHTS.put(SculptorMusicSection.LEVEL3_1, Float.valueOf(0.65f));
        SECTION_HEIGHTS.put(SculptorMusicSection.LEVEL3_2, Float.valueOf(0.825f));
        SECTION_HEIGHTS.put(SculptorMusicSection.ENDING, Float.valueOf(0.98f));
        SECTION_SOUNDS = new HashMap<SculptorMusicSection, SoundEvent>();
        SECTION_SOUNDS.put(SculptorMusicSection.INTRO, soundEventIntro);
        SECTION_SOUNDS.put(SculptorMusicSection.LEVEL1_1, soundEventLevel1_1);
        SECTION_SOUNDS.put(SculptorMusicSection.LEVEL1_2, soundEventLevel1_2);
        SECTION_SOUNDS.put(SculptorMusicSection.LEVEL2_1, soundEventLevel2_1);
        SECTION_SOUNDS.put(SculptorMusicSection.LEVEL2_2, soundEventLevel2_2);
        SECTION_SOUNDS.put(SculptorMusicSection.TRANSITION, soundEventTransition);
        SECTION_SOUNDS.put(SculptorMusicSection.LEVEL3_1, soundEventLevel3_1);
        SECTION_SOUNDS.put(SculptorMusicSection.LEVEL3_2, soundEventLevel3_2);
        SECTION_SOUNDS.put(SculptorMusicSection.ENDING, soundEventEnding);
        SECTION_SOUNDS.put(SculptorMusicSection.OUTRO, soundEventOutro);
        SECTION_SOUNDS.put(SculptorMusicSection.COMBAT, soundEventCombat);
    }

    private static enum SculptorMusicSection {
        COMBAT(-1),
        INTRO(0),
        LEVEL1_1(1),
        LEVEL1_2(2),
        LEVEL2_1(3),
        LEVEL2_2(4),
        TRANSITION(5),
        LEVEL3_1(6),
        LEVEL3_2(7),
        ENDING(8),
        OUTRO(9);

        private Integer order;

        private SculptorMusicSection(int order) {
            this.order = order;
        }

        public boolean isHigherThan(SculptorMusicSection other) {
            return this.order > other.order;
        }
    }
}

