/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.datagen.MMItemTags;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.advancement.SculptorFailureTrigger;
import com.bobmowzie.mowziesmobs.server.ai.AvoidEntityIfNotTamedGoal;
import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCrane;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollowerToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemNagaFangDagger;
import com.bobmowzie.mowziesmobs.server.item.ItemSpear;
import com.bobmowzie.mowziesmobs.server.item.ItemUmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.message.MessageFreezeEffect;
import com.bobmowzie.mowziesmobs.server.message.MessageSunblockEffect;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.power.Power;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class ServerEventHandler {
    private static final ResourceLocation GEOMANCY_BELT_DEFENSE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geomancy_belt_defense_boost");
    private static final AttributeModifier DEFENSE_MODIFIER_BELT = new AttributeModifier(GEOMANCY_BELT_DEFENSE, 4.0, AttributeModifier.Operation.ADD_VALUE);
    private static final ResourceLocation GEOMANCY_BELT_KNOCKBACK_RESISTANCE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geomancy_belt_knockback_resistance_boost");
    private static final AttributeModifier KNOCKBACK_MODIFIER_BELT = new AttributeModifier(GEOMANCY_BELT_KNOCKBACK_RESISTANCE, 1.0, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier ATTACK_MODIFIER_BEADS = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geomancy_beads_attack_boost"), 3.0, AttributeModifier.Operation.ADD_VALUE);

    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Player || event.getEntity() instanceof MowzieGeckoEntity) {
            DataHandler.getData(event.getEntity(), DataHandler.ABILITY_DATA).instanceAbilities((LivingEntity)event.getEntity());
        }
        if (event.getEntity() instanceof Player) {
            DataHandler.getData(event.getEntity(), DataHandler.PLAYER_DATA).addedToWorld(event);
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Zombie && !(entity instanceof ZombifiedPiglin)) {
            ((PathfinderMob)entity).targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityFoliaath.class, 0, true, false, null));
            ((PathfinderMob)entity).targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthana.class, 0, true, false, null));
            ((PathfinderMob)entity).targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthi.class, 0, true, false, null));
        }
        if (entity instanceof AbstractSkeleton) {
            ((PathfinderMob)entity).targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthana.class, 0, true, false, null));
            ((PathfinderMob)entity).targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthi.class, 0, true, false, null));
        }
        if (entity instanceof Parrot) {
            ((PathfinderMob)entity).goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof Animal) {
            ((PathfinderMob)entity).goalSelector.addGoal(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityUmvuthana.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityUmvuthi.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityNaga.class, 10.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof AbstractVillager) {
            ((PathfinderMob)entity).goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityUmvuthana.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityUmvuthi.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityNaga.class, 10.0f, 1.0, 1.2));
            ((PathfinderMob)entity).goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof Pillager) {
            ((PathfinderMob)entity).targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntitySculptor.class, 0, true, false, null));
        }
    }

    @SubscribeEvent
    public void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            Item headItemStack;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.getEffect(EffectHandler.POISON_RESIST) != null && livingEntity.getEffect(MobEffects.POISON) != null) {
                livingEntity.removeEffectNoUpdate(MobEffects.POISON);
            }
            if (!livingEntity.level().isClientSide && (headItemStack = livingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof ItemUmvuthanaMask) {
                ItemUmvuthanaMask mask = (ItemUmvuthanaMask)headItemStack;
                EffectHandler.addOrCombineEffect(livingEntity, mask.getPotion(), 50, 0, true, false);
            }
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                if (!(livingEntity instanceof EntityUmvuthanaCrane) && mob.getTarget() instanceof EntityUmvuthi && mob.getTarget().hasEffect(EffectHandler.SUNBLOCK)) {
                    EntityUmvuthanaCrane sunblocker = (EntityUmvuthanaCrane)mob.level().getNearestEntity(EntityUmvuthanaCrane.class, TargetingConditions.DEFAULT, (LivingEntity)mob, mob.getX(), mob.getY() + (double)mob.getEyeHeight(), mob.getZ(), mob.getBoundingBox().inflate(40.0, 15.0, 40.0));
                    mob.setTarget((LivingEntity)sunblocker);
                }
            }
            DataHandler.getData((Entity)livingEntity, DataHandler.FROZEN_DATA).tick(livingEntity);
            DataHandler.getData((Entity)livingEntity, DataHandler.LIVING_DATA).tick(livingEntity);
            DataHandler.getData((Entity)livingEntity, DataHandler.ABILITY_DATA).tick(livingEntity);
            AttributeInstance attributeInstanceArmor = livingEntity.getAttribute(Attributes.ARMOR);
            AttributeInstance attributeInstanceKnockbackRes = livingEntity.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            if (livingEntity.getItemBySlot(EquipmentSlot.LEGS).is((Item)ItemHandler.GEOMANCER_BELT.get()) && livingEntity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                if (attributeInstanceArmor != null && !attributeInstanceArmor.hasModifier(GEOMANCY_BELT_DEFENSE)) {
                    attributeInstanceArmor.addTransientModifier(DEFENSE_MODIFIER_BELT);
                }
                if (attributeInstanceKnockbackRes != null && !attributeInstanceKnockbackRes.hasModifier(GEOMANCY_BELT_KNOCKBACK_RESISTANCE)) {
                    attributeInstanceKnockbackRes.addTransientModifier(KNOCKBACK_MODIFIER_BELT);
                }
            } else {
                if (attributeInstanceArmor != null && attributeInstanceArmor.hasModifier(GEOMANCY_BELT_DEFENSE)) {
                    attributeInstanceArmor.removeModifier(DEFENSE_MODIFIER_BELT);
                }
                if (attributeInstanceKnockbackRes != null && attributeInstanceKnockbackRes.hasModifier(GEOMANCY_BELT_KNOCKBACK_RESISTANCE)) {
                    attributeInstanceKnockbackRes.removeModifier(KNOCKBACK_MODIFIER_BELT);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAddPotionEffect(MobEffectEvent.Added event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect() == EffectHandler.SUNBLOCK) {
            if (!event.getEntity().level().isClientSide()) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageSunblockEffect(event.getEntity().getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            MMCommon.PROXY.playSunblockSound(event.getEntity());
        }
        if (event.getEffectInstance().getEffect() == EffectHandler.FROZEN && !event.getEntity().level().isClientSide()) {
            DataHandler.getData((Entity)event.getEntity(), DataHandler.FROZEN_DATA).onFreeze(event.getEntity());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageFreezeEffect(event.getEntity().getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onRemovePotionEffect(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        if (!event.getEntity().level().isClientSide() && event.getEffectInstance().getEffect() == EffectHandler.SUNBLOCK) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageSunblockEffect(event.getEntity().getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!event.getEntity().level().isClientSide() && event.getEffectInstance().getEffect() == EffectHandler.FROZEN) {
            DataHandler.getData((Entity)event.getEntity(), DataHandler.FROZEN_DATA).onUnfreeze(event.getEntity());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageFreezeEffect(event.getEntity().getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onPotionEffectExpire(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().level().isClientSide() && effectInstance != null && effectInstance.getEffect() == EffectHandler.SUNBLOCK) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageSunblockEffect(event.getEntity().getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!event.getEntity().level().isClientSide() && effectInstance != null && effectInstance.getEffect() == EffectHandler.FROZEN) {
            DataHandler.getData((Entity)event.getEntity(), DataHandler.FROZEN_DATA).onUnfreeze(event.getEntity());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageFreezeEffect(event.getEntity().getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Post event) {
        LivingEntity j2;
        int i;
        int j2;
        float f;
        float f1;
        float f2;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        float damage = event.getNewDamage();
        if (!source.is(DamageTypeTags.BYPASSES_RESISTANCE) && livingEntity.hasEffect(EffectHandler.SUNBLOCK) && !source.is(DamageTypes.FELL_OUT_OF_WORLD) && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j2 = 25 - (i = (livingEntity.getEffect(EffectHandler.SUNBLOCK).getAmplifier() + 2) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (livingEntity instanceof ServerPlayer) {
                ((ServerPlayer)livingEntity).awardStat(Stats.DAMAGE_RESISTED, Math.round(f2 * 10.0f));
            } else if (source.getEntity() instanceof ServerPlayer) {
                ((ServerPlayer)source.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f2 * 10.0f));
            }
        }
        if (event.getSource().is(DamageTypeTags.IS_FIRE)) {
            event.getEntity().removeEffectNoUpdate(EffectHandler.FROZEN);
            DataHandler.getData((Entity)event.getEntity(), DataHandler.FROZEN_DATA).onUnfreeze(event.getEntity());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageFreezeEffect(event.getEntity().getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if ((j2 = event.getEntity()) instanceof Player) {
            Power[] powers;
            Player player = (Player)j2;
            for (Power power : powers = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getPowers()) {
                power.onTakeDamage(event);
            }
            if (player.getItemBySlot(EquipmentSlot.CHEST).is((Item)ItemHandler.GEOMANCER_ROBE.get())) {
                this.spawnBoulderNearPlayer(player);
            }
        }
        DataHandler.getData((Entity)event.getEntity(), DataHandler.LIVING_DATA).setLastDamage(event.getNewDamage());
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Power[] powers;
        Player player = event.getEntity();
        PlayerData data = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA);
        data.tick((PlayerTickEvent)event);
        for (Power power : powers = data.getPowers()) {
            power.tick((PlayerTickEvent)event);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity().getItemBySlot(EquipmentSlot.FEET).is((Item)ItemHandler.GEOMANCER_SANDALS.get()) && event.getDistance() > 4.0f) {
            EffectHandler.addOrCombineEffect(event.getEntity(), (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 60, 0, false, false);
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent.Start event) {
        LivingEntity living = event.getEntity();
        if (living.hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)living, DataHandler.ABILITY_DATA).itemUsePrevented(event.getItem())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.hasEffect(EffectHandler.FROZEN)) {
                event.setCanceled(true);
                return;
            }
            if (DataHandler.getData((Entity)living, DataHandler.ABILITY_DATA).blockBreakingBuildingPrevented()) {
                event.setCanceled(true);
                return;
            }
            if (entity instanceof Player) {
                this.cheatSculptor((Player)entity);
                BlockState block = event.getPlacedBlock();
                if (block.getBlock() == Blocks.FIRE || block.getBlock() == Blocks.TNT || block.getBlock() == Blocks.RESPAWN_ANCHOR || block.getBlock() == Blocks.DISPENSER || block.getBlock() == Blocks.CACTUS) {
                    this.aggroUmvuthana((Player)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Player player;
        PlayerData data;
        EntitySculptor sculptor;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (sculptor = (data = DataHandler.getData((Entity)(player = (Player)livingEntity), DataHandler.PLAYER_DATA)).getTestingSculptor()) != null && sculptor.getTestingPlayer() == player && event.getSource() == player.damageSources().fall() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((SculptorFailureTrigger)((Object)AdvancementHandler.SCULPTOR_FAILURE_TRIGGER.get())).trigger(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onFillBucket(PlayerInteractEvent.RightClickItem event) {
        Item item = event.getItemStack().getItem();
        if (item == Items.LAVA_BUCKET) {
            this.aggroUmvuthana(event.getEntity());
        }
        if (item == Items.WATER_BUCKET) {
            this.cheatSculptor(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)event.getPlayer(), DataHandler.ABILITY_DATA).blockBreakingBuildingPrevented()) {
            event.setCanceled(true);
            return;
        }
        this.cheatSculptor(event.getPlayer());
        BlockState block = event.getState();
        if (block.getBlock() == Blocks.GOLD_BLOCK || block.is(BlockTags.PLANKS) || block.is(BlockTags.LOGS) || block.is(BlockTags.LEAVES) || block.getBlock() == Blocks.LIGHT_GRAY_TERRACOTTA || block.getBlock() == Blocks.RED_TERRACOTTA || block.getBlock() == Blocks.SMOOTH_RED_SANDSTONE_SLAB || block.getBlock() == Blocks.SMOOTH_RED_SANDSTONE || block.getBlock() == Blocks.SMOOTH_RED_SANDSTONE_STAIRS || block.getBlock() == Blocks.CAMPFIRE || block.getBlock() == Blocks.IRON_BARS || block.getBlock() == Blocks.SKELETON_SKULL || block.getBlock() == Blocks.TORCH || block.getBlock() == Blocks.CHEST) {
            this.aggroUmvuthana(event.getPlayer());
        }
    }

    public <T extends Entity> List<T> getEntitiesNearby(Entity startEntity, Class<T> entityClass, double r) {
        return startEntity.level().getEntitiesOfClass(entityClass, startEntity.getBoundingBox().inflate(r, r, r), e -> e != startEntity && (double)startEntity.distanceTo(e) <= r);
    }

    private List<LivingEntity> getEntityBaseNearby(LivingEntity user, double distanceX, double distanceY, double distanceZ, double radius) {
        List list = user.level().getEntities((Entity)user, user.getBoundingBox().inflate(distanceX, distanceY, distanceZ));
        return list.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && (double)user.distanceTo(entityNeighbor) <= radius).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        Power[] powers;
        if (event.getEntity().hasEffect(EffectHandler.FROZEN)) {
            return;
        }
        if (DataHandler.getData((Entity)event.getEntity(), DataHandler.ABILITY_DATA).interactingPrevented()) {
            return;
        }
        Player player = event.getEntity();
        if (event.getLevel().isClientSide && player.getInventory().getSelected().isEmpty() && player.hasEffect(EffectHandler.SUNS_BLESSING)) {
            if (player.isShiftKeyDown()) {
                AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SOLAR_BEAM_ABILITY);
            } else {
                AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SUNSTRIKE_ABILITY);
            }
        }
        for (Power power : powers = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getPowers()) {
            power.onRightClickEmpty(event);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        Power[] powers;
        if (event.getEntity().hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)event.getEntity(), DataHandler.ABILITY_DATA).interactingPrevented()) {
            event.setCanceled(true);
            return;
        }
        for (Power power : powers = DataHandler.getData((Entity)event.getEntity(), DataHandler.PLAYER_DATA).getPowers()) {
            power.onRightClickEntity(event);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Power[] powers;
        ItemStack item;
        if (event.getEntity().hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)event.getEntity(), DataHandler.ABILITY_DATA).interactingPrevented()) {
            event.setCanceled(true);
            return;
        }
        Player player = event.getEntity();
        if (player.level().getBlockState(event.getPos()).getBlock() instanceof ChestBlock) {
            this.aggroUmvuthana(player);
        }
        if ((item = event.getItemStack()).getItem() == Items.FLINT_AND_STEEL || item.getItem() == Items.TNT_MINECART) {
            this.aggroUmvuthana(player);
        }
        if (player.level().isClientSide() && player.getInventory().getSelected().isEmpty() && player.hasEffect(EffectHandler.SUNS_BLESSING) && player.level().getBlockState(event.getPos()).getMenuProvider(player.level(), event.getPos()) == null) {
            if (player.isShiftKeyDown()) {
                AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SOLAR_BEAM_ABILITY);
            } else {
                AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SUNSTRIKE_ABILITY);
            }
        }
        if (player.getMainHandItem().is((Item)ItemHandler.WROUGHT_AXE.get()) && player.level().getBlockState(event.getPos()).getMenuProvider(player.level(), event.getPos()) != null) {
            player.resetAttackStrengthTicker();
            return;
        }
        for (Power power : powers = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getPowers()) {
            power.onRightClickBlock(event);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Power[] powers;
        Player player = event.getEntity();
        for (Power power : powers = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getPowers()) {
            power.onLeftClickEmpty(event);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Post event) {
        Player player;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        if (entity2.getHealth() <= event.getNewDamage() && entity2.hasEffect(EffectHandler.FROZEN)) {
            entity2.removeEffectNoUpdate(EffectHandler.FROZEN);
            DataHandler.getData((Entity)entity2, DataHandler.FROZEN_DATA).onUnfreeze(entity2);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new MessageFreezeEffect(event.getEntity().getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (event.getNewDamage() > 0.0f && (entity = event.getSource().getEntity()) instanceof Player && (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST).is((Item)ItemHandler.GEOMANCER_ROBE.get())) {
            this.spawnBoulderNearPlayer(player);
        }
        if (entity2 instanceof Player) {
            EntitySculptor sculptor;
            PlayerData data;
            player = (Player)entity2;
            if (event.getSource() == player.damageSources().fall() && player.getHealth() <= event.getNewDamage() && (data = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA)).getTestingSculptor() != null && (sculptor = data.getTestingSculptor()).getTestingPlayer() == player && player instanceof ServerPlayer) {
                ((SculptorFailureTrigger)((Object)AdvancementHandler.SCULPTOR_FAILURE_TRIGGER.get())).trigger((ServerPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        Power[] powers;
        if (event.getEntity().hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)event.getEntity(), DataHandler.ABILITY_DATA).itemUsePrevented(event.getItemStack())) {
            event.setCanceled(true);
            return;
        }
        for (Power power : powers = DataHandler.getData((Entity)event.getEntity(), DataHandler.PLAYER_DATA).getPowers()) {
            power.onRightClickWithItem(event);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Power[] powers;
        Player player = event.getEntity();
        if (player.hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)event.getEntity(), DataHandler.ABILITY_DATA).blockBreakingBuildingPrevented()) {
            event.setCanceled(true);
            return;
        }
        for (Power power : powers = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getPowers()) {
            power.onLeftClickBlock(event);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(EffectHandler.FROZEN) && entity.onGround()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
        }
        if (event.getEntity() instanceof Player) {
            Power[] powers;
            for (Power power : powers = DataHandler.getData((Entity)event.getEntity(), DataHandler.PLAYER_DATA).getPowers()) {
                power.onJump(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        ItemFrame itemFrame;
        Power[] powers;
        if (event.getEntity().hasEffect(EffectHandler.FROZEN)) {
            event.setCanceled(true);
            return;
        }
        if (DataHandler.getData((Entity)event.getEntity(), DataHandler.ABILITY_DATA).attackingPrevented()) {
            event.setCanceled(true);
            return;
        }
        PlayerData data = DataHandler.getData((Entity)event.getEntity(), DataHandler.PLAYER_DATA);
        data.setPrevCooledAttackStrength(event.getEntity().getAttackStrengthScale(0.5f));
        for (Power power : powers = data.getPowers()) {
            power.onLeftClickEntity(event);
        }
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrame && (itemFrame = (ItemFrame)entity).getItem().getItem() instanceof ItemUmvuthanaMask) {
            this.aggroUmvuthana(event.getEntity());
        }
        if (event.getTarget() instanceof LeaderSunstrikeImmune) {
            this.aggroUmvuthana(event.getEntity());
        }
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        if (event.getTarget() instanceof EntityUmvuthanaFollowerToPlayer) {
            return;
        }
        if (!event.getEntity().level().isClientSide()) {
            for (int i = 0; i < data.getPackSize(); ++i) {
                EntityUmvuthanaFollowerToPlayer umvuthana = data.getUmvuthanaPack().get(i);
                LivingEntity living = (LivingEntity)event.getTarget();
                if (umvuthana.getMaskType() == MaskType.FAITH || living.isInvulnerable()) continue;
                umvuthana.setTarget(living);
            }
        }
    }

    @SubscribeEvent
    public void checkCritEvent(CriticalHitEvent event) {
        Entity entity;
        ItemStack weapon = event.getEntity().getMainHandItem();
        Player attacker = event.getEntity();
        if (DataHandler.getData((Entity)attacker, DataHandler.PLAYER_DATA).getPrevCooledAttackStrength() == 1.0f && !weapon.isEmpty() && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (weapon.getItem() instanceof ItemNagaFangDagger) {
                Vec3 vecBetween;
                Vec3 lookDir = new Vec3(target.getLookAngle().x, 0.0, target.getLookAngle().z).normalize();
                double dot = lookDir.dot(vecBetween = new Vec3(target.getX() - event.getEntity().getX(), 0.0, target.getZ() - event.getEntity().getZ()).normalize());
                if (dot > 0.7) {
                    event.setCriticalHit(true);
                    event.setDamageMultiplier(event.getDamageMultiplier() + ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.NAGA_FANG_DAGGER.backstabDamageMultiplier.get()).floatValue());
                    target.playSound((SoundEvent)MMSounds.ENTITY_NAGA_ACID_HIT.get(), 1.0f, 1.2f);
                    AbilityHandler.INSTANCE.sendAbilityMessage(attacker, AbilityHandler.BACKSTAB_ABILITY);
                    if (target.level().isClientSide()) {
                        double life;
                        double value;
                        Vec3 particlePos;
                        int i;
                        Vec3 ringOffset = attacker.getLookAngle().scale((double)(-target.getBbWidth() / 2.0f));
                        ParticleRotation.OrientVector rotation = new ParticleRotation.OrientVector(ringOffset);
                        Vec3 pos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).add(ringOffset);
                        AdvancedParticleBase.spawnParticle(target.level(), ParticleHandler.RING_SPARKS, pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0, rotation, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 6.0, false, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 15.0f), false)});
                        RandomSource rand = attacker.level().getRandom();
                        float explodeSpeed = 2.5f;
                        for (i = 0; i < 10; ++i) {
                            particlePos = new Vec3((double)rand.nextFloat() * 0.25, 0.0, 0.0);
                            particlePos = particlePos.yRot((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                            particlePos = particlePos.xRot((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                            value = rand.nextFloat() * 0.1f;
                            life = rand.nextFloat() * 8.0f + 15.0f;
                            ParticleVanillaCloudExtended.spawnVanillaCloud(target.level(), pos.x(), pos.y(), pos.z(), particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                        }
                        for (i = 0; i < 10; ++i) {
                            particlePos = new Vec3((double)rand.nextFloat() * 0.25, 0.0, 0.0);
                            particlePos = particlePos.yRot((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                            particlePos = particlePos.xRot((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                            value = rand.nextFloat() * 0.1f;
                            life = rand.nextFloat() * 2.5f + 5.0f;
                            AdvancedParticleBase.spawnParticle(target.level(), ParticleHandler.PIXEL, pos.x(), pos.y(), pos.z(), particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false, true);
                        }
                        for (i = 0; i < 6; ++i) {
                            particlePos = new Vec3((double)rand.nextFloat() * 0.25, 0.0, 0.0);
                            particlePos = particlePos.yRot((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                            particlePos = particlePos.xRot((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                            value = rand.nextFloat() * 0.1f;
                            life = rand.nextFloat() * 5.0f + 10.0f;
                            AdvancedParticleBase.spawnParticle(target.level(), ParticleHandler.BUBBLE, pos.x(), pos.y(), pos.z(), particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false, true);
                        }
                    }
                }
            } else if (weapon.getItem() instanceof ItemSpear && target instanceof Animal && target.getMaxHealth() <= 30.0f && (double)attacker.level().getRandom().nextFloat() <= 0.334) {
                event.setCriticalHit(true);
                event.setDamageMultiplier(400.0f);
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity equipper = event.getEntity();
        ItemStack weapon = equipper.getItemBySlot(EquipmentSlot.MAINHAND);
        AttributeInstance attributeinstance = equipper.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attributeinstance != null && (event.getSlot() == EquipmentSlot.HEAD || event.getSlot() == EquipmentSlot.MAINHAND)) {
            attributeinstance.removeModifier(ATTACK_MODIFIER_BEADS);
            if (equipper.getItemBySlot(EquipmentSlot.HEAD).is((Item)ItemHandler.GEOMANCER_BEADS.get()) && (weapon.is(MMItemTags.HAND_WEAPONS) || weapon.isEmpty())) {
                attributeinstance.addTransientModifier(ATTACK_MODIFIER_BEADS);
            }
        }
    }

    @SubscribeEvent
    public void onRideEntity(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityUmvuthi || event.getEntityMounting() instanceof EntityFrostmaw || event.getEntityMounting() instanceof EntityWroughtnaut || event.getEntityMounting() instanceof EntitySculptor) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        List<MowzieEntity> mobs = this.getEntitiesNearby((Entity)event.getEntity(), MowzieEntity.class, 40.0);
        for (MowzieEntity mob : mobs) {
            if (!mob.resetHealthOnPlayerRespawn()) continue;
            mob.setHealth(mob.getMaxHealth());
        }
    }

    @SubscribeEvent
    public void onSpawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck event) {
        StructureManager structureManager = event.getLevel().getLevel().structureManager();
        Structure structure = (Structure)structureManager.registryAccess().registryOrThrow(Registries.STRUCTURE).get(StructureTypeHandler.MONASTERY.getId());
        if (event.getEntityType().getCategory() == MobCategory.MONSTER && structure != null && structureManager.getStructureAt(event.getPos(), structure).isValid()) {
            BlockState ground = event.getLevel().getBlockState(event.getPos().below());
            if (event.getLevel().canSeeSky(event.getPos()) && (ground.is(Blocks.DARK_OAK_PLANKS) || ground.is(Blocks.DARK_OAK_SLAB) || ground.is(Blocks.DARK_OAK_STAIRS))) {
                event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
            }
        }
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().is(((Block)BlockHandler.CLAWED_LOG.get()).asItem()) || event.getItemStack().is(((Block)BlockHandler.PAINTED_ACACIA.get()).asItem())) {
            event.setBurnTime(300);
        } else if (event.getItemStack().is(((Block)BlockHandler.PAINTED_ACACIA_SLAB.get()).asItem())) {
            event.setBurnTime(150);
        } else if (event.getItemStack().is(((Block)BlockHandler.THATCH.get()).asItem())) {
            event.setBurnTime(100);
        }
    }

    private void aggroUmvuthana(Player player) {
        List<EntityUmvuthi> barakos = this.getEntitiesNearby((Entity)player, EntityUmvuthi.class, 50.0);
        for (EntityUmvuthi barako : barakos) {
            if (barako.getTarget() != null && barako.getTarget() instanceof Player || player.isCreative() || player.isSpectator() || !(player.blockPosition().distSqr((Vec3i)barako.getRestrictCenter()) < 900.0) || !barako.canAttack((LivingEntity)player)) continue;
            barako.setMisbehavedPlayerId(player.getUUID());
        }
        List<EntityUmvuthanaMinion> barakoas = this.getEntitiesNearby((Entity)player, EntityUmvuthanaMinion.class, 50.0);
        for (EntityUmvuthanaMinion barakoa : barakoas) {
            if (barakoa.getTarget() != null && barakoa.getTarget() instanceof Player || !(player.blockPosition().distSqr((Vec3i)barakoa.getRestrictCenter()) < 900.0) || !barakoa.canAttack((LivingEntity)player)) continue;
            barakoa.setMisbehavedPlayerId(player.getUUID());
        }
    }

    private void cheatSculptor(Player player) {
        List sculptors = player.level().getEntitiesOfClass(EntitySculptor.class, player.getBoundingBox().inflate((double)(EntitySculptor.TEST_RADIUS + 3), (double)EntitySculptor.TEST_HEIGHT, (double)(EntitySculptor.TEST_RADIUS + 3)), EntitySculptor::isTesting);
        for (EntitySculptor sculptor : sculptors) {
            sculptor.playerCheated();
        }
    }

    private void spawnBoulderNearPlayer(Player player) {
        if ((double)player.getRandom().nextFloat() > 0.5) {
            return;
        }
        int i = Mth.floor((double)player.getX());
        int j = Mth.floor((double)player.getY());
        int k = Mth.floor((double)player.getZ());
        for (int l = 0; l < 10; ++l) {
            int searchDist;
            double radius = Math.pow(player.getRandom().nextFloat(), 0.5) * 10.0 + 3.0;
            double angle = (double)player.getRandom().nextFloat() * Math.PI * 2.0;
            int i1 = i + (int)(Math.cos(angle) * radius);
            int j1 = j + Mth.nextInt((RandomSource)player.getRandom(), (int)0, (int)15) * Mth.nextInt((RandomSource)player.getRandom(), (int)-1, (int)1);
            int k1 = k + (int)(Math.sin(angle) * radius);
            BlockPos spawnBoulderPos = new BlockPos(i1, j1, k1);
            BlockState state = player.level().getBlockState(spawnBoulderPos);
            int maxSearchDist = 10;
            for (searchDist = 0; state.canBeReplaced() && searchDist < maxSearchDist; ++searchDist) {
                spawnBoulderPos = spawnBoulderPos.below();
                state = player.level().getBlockState(spawnBoulderPos);
            }
            for (searchDist = 0; !state.canBeReplaced() && searchDist < maxSearchDist; ++searchDist) {
                spawnBoulderPos = spawnBoulderPos.above();
                state = player.level().getBlockState(spawnBoulderPos);
            }
            spawnBoulderPos = spawnBoulderPos.below();
            state = player.level().getBlockState(spawnBoulderPos);
            if (!EffectGeomancy.isBlockUseable(state)) continue;
            EntityBoulderProjectile boulder = new EntityBoulderProjectile((EntityType<? extends EntityBoulderProjectile>)((EntityType)EntityHandler.BOULDER_PROJECTILE.get()), player.level(), (LivingEntity)player, state, spawnBoulderPos, EntityGeomancyBase.GeomancyTier.SMALL);
            boulder.setPos((float)spawnBoulderPos.getX() + 0.5f, spawnBoulderPos.getY() + 2, (float)spawnBoulderPos.getZ() + 0.5f);
            if (player.level().isClientSide || !boulder.checkCanSpawn()) continue;
            player.level().addFreshEntity((Entity)boulder);
            break;
        }
    }
}

