/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.server.block.ICopiedBlockProperties;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class EntityGeomancyBase
extends EntityMagicEffect
implements GeoEntity {
    private static final byte EXPLOSION_PARTICLES_ID = 69;
    protected static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(EntityGeomancyBase.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.defineId(EntityGeomancyBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DEATH_TIME = SynchedEntityData.defineId(EntityGeomancyBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean doRemoveTimer = true;

    public EntityGeomancyBase(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityGeomancyBase(EntityType<? extends EntityMagicEffect> type, Level worldIn, LivingEntity caster, BlockState blockState, BlockPos pos) {
        super(type, worldIn, caster);
        if (!worldIn.isClientSide && blockState != null && EffectGeomancy.isBlockUseable(blockState)) {
            BlockState newBlock = this.changeBlock(blockState);
            this.setBlock(newBlock);
        }
    }

    public BlockState changeBlock(BlockState blockState) {
        ResourceKey blockKey;
        ICopiedBlockProperties properties;
        Block baseBlock;
        if (!blockState.is(TagHandler.GEOMANCY_USEABLE) && (baseBlock = (properties = (ICopiedBlockProperties)blockState.getBlock().properties()).mowziesMobs$getBaseBlock()) != null) {
            blockState = baseBlock.defaultBlockState();
        }
        if ((blockKey = blockState.getBlock().builtInRegistryHolder().getKey()) != null) {
            String blockString = blockKey.location().toString();
            if (blockState.getBlock() instanceof SlabBlock && blockString.endsWith("_slab")) {
                Registry blockRegistry;
                Optional optional;
                Object baseBlockString = blockString.substring(0, blockString.lastIndexOf(95));
                if (((String)baseBlockString).endsWith("brick")) {
                    baseBlockString = (String)baseBlockString + "s";
                }
                if ((optional = (blockRegistry = this.level().registryAccess().registryOrThrow(Registries.BLOCK)).getOptional(ResourceLocation.tryParse((String)baseBlockString))).isPresent()) {
                    blockState = ((Block)optional.get()).defaultBlockState();
                }
            }
        }
        if (blockState.getBlock() == Blocks.GRASS_BLOCK || blockState.getBlock() == Blocks.MYCELIUM || blockState.getBlock() == Blocks.PODZOL || blockState.getBlock() == Blocks.DIRT_PATH) {
            blockState = Blocks.DIRT.defaultBlockState();
        } else if (blockState.is(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE)) {
            blockState = Blocks.DEEPSLATE.defaultBlockState();
        } else if (blockState.is(BlockTags.NYLIUM)) {
            blockState = Blocks.NETHERRACK.defaultBlockState();
        } else if (blockState.is(Tags.Blocks.ORES_IN_GROUND_NETHERRACK)) {
            blockState = Blocks.NETHERRACK.defaultBlockState();
        } else if (blockState.is(Tags.Blocks.ORES_IN_GROUND_STONE)) {
            blockState = Blocks.STONE.defaultBlockState();
        } else if (blockState.is(Tags.Blocks.SANDS_RED)) {
            blockState = Blocks.RED_SANDSTONE.defaultBlockState();
        } else if (blockState.is(Tags.Blocks.SANDS_COLORLESS)) {
            blockState = Blocks.SANDSTONE.defaultBlockState();
        } else if (blockState.getBlock() == Blocks.SOUL_SAND) {
            blockState = Blocks.SOUL_SOIL.defaultBlockState();
        }
        return blockState;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.doRemoveTimer()) {
            int newDeathTime = this.getDeathTime() - 1;
            this.setDeathTime(newDeathTime);
            if (newDeathTime < 0) {
                this.explode();
            }
        }
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLOCK_STATE, (Object)Blocks.DIRT.defaultBlockState());
        builder.define(DEATH_TIME, (Object)1200);
        builder.define(TIER, (Object)0);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public boolean isSilent() {
        return false;
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        super.playSound(soundIn, volume, pitch + this.random.nextFloat() * 0.25f - 0.125f);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    protected void explode() {
        this.level().broadcastEntityEvent((Entity)this, (byte)69);
        GeomancyTier tier = this.getTier();
        if (tier == GeomancyTier.NONE) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.5f, 1.0f);
        }
        if (tier == GeomancyTier.SMALL) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.5f, 1.0f);
        } else if (tier == GeomancyTier.MEDIUM) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.7f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_3.get(), 1.5f, 1.5f);
        } else if (tier == GeomancyTier.LARGE) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.0f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_1.get(), 1.5f, 0.9f);
            EntityCameraShake.cameraShake(this.level(), this.position(), 15.0f, 0.05f, 0, 20);
            int i = 0;
            while ((float)i < 5.0f * this.fallingBlockCountMultiplier()) {
                Vec3 particlePos = new Vec3((double)(this.random.nextFloat() * 2.0f), 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.add(new Vec3(0.0, (double)(this.getBbHeight() / 4.0f), 0.0));
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), 70, this.getBlock());
                fallingBlock.setPos(this.getX() + particlePos.x, this.getY() + 0.5 + particlePos.y, this.getZ() + particlePos.z);
                fallingBlock.setDeltaMovement((float)particlePos.x * 0.3f, 0.2f + this.random.nextFloat() * 0.6f, (float)particlePos.z * 0.3f);
                this.level().addFreshEntity((Entity)fallingBlock);
                ++i;
            }
        } else if (tier == GeomancyTier.HUGE) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 0.5f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 1.5f, 0.5f);
            EntityCameraShake.cameraShake(this.level(), this.position(), 20.0f, 0.05f, 0, 20);
            int i = 0;
            while ((float)i < 7.0f * this.fallingBlockCountMultiplier()) {
                Vec3 particlePos = new Vec3((double)(this.random.nextFloat() * 2.5f), 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.add(new Vec3(0.0, (double)(this.getBbHeight() / 4.0f), 0.0));
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), 70, this.getBlock());
                fallingBlock.setPos(this.getX() + particlePos.x, this.getY() + 0.5 + particlePos.y, this.getZ() + particlePos.z);
                fallingBlock.setDeltaMovement((float)particlePos.x * 0.3f, 0.2f + this.random.nextFloat() * 0.6f, (float)particlePos.z * 0.3f);
                this.level().addFreshEntity((Entity)fallingBlock);
                ++i;
            }
        }
        this.discard();
    }

    protected float fallingBlockCountMultiplier() {
        return 1.0f;
    }

    protected void spawnExplosionParticles() {
        int i = 0;
        while ((float)i < 40.0f * this.getBbWidth()) {
            Vec3 particlePos = new Vec3((double)this.random.nextFloat() * 0.7 * (double)this.getBbWidth(), 0.0, 0.0);
            particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
            particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
            particlePos = particlePos.add(0.0, (double)this.getBbHeight() / 2.0, 0.0);
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            boolean overrideLimiter = camera.getPosition().distanceToSqr(this.getX(), this.getY(), this.getZ()) < 4096.0;
            this.level().addAlwaysVisibleParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlock()), overrideLimiter, this.getX() + particlePos.x, this.getY() + 0.5 + particlePos.y, this.getZ() + particlePos.z, particlePos.x, particlePos.y, particlePos.z);
            ++i;
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 69) {
            this.spawnExplosionParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public BlockState getBlock() {
        return (BlockState)this.getEntityData().get(BLOCK_STATE);
    }

    public void setBlock(BlockState block) {
        this.getEntityData().set(BLOCK_STATE, (Object)block);
    }

    public GeomancyTier getTier() {
        return GeomancyTier.values()[(Integer)this.entityData.get(TIER)];
    }

    public void setTier(GeomancyTier size) {
        this.entityData.set(TIER, (Object)size.ordinal());
    }

    public int getDeathTime() {
        return (Integer)this.entityData.get(DEATH_TIME);
    }

    public void setDeathTime(int deathTime) {
        this.entityData.set(DEATH_TIME, (Object)deathTime);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.put("block", (Tag)NbtUtils.writeBlockState((BlockState)blockState));
        }
        if (this.doRemoveTimer()) {
            compound.putInt("deathTime", this.getDeathTime());
        }
        compound.putInt("tier", this.getTier().ordinal());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Tag blockStateCompound = compound.get("block");
        if (blockStateCompound != null) {
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)((CompoundTag)blockStateCompound));
            this.setBlock(blockState);
        }
        if (compound.contains("deathTime")) {
            this.doRemoveTimer = true;
            this.setDeathTime(compound.getInt("deathTime"));
        } else {
            this.doRemoveTimer = false;
        }
        this.setTier(GeomancyTier.values()[compound.getInt("tier")]);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean doRemoveTimer() {
        return this.doRemoveTimer;
    }

    public void setDoRemoveTimer(boolean doRemoveTimer) {
        this.doRemoveTimer = doRemoveTimer;
    }

    public static enum GeomancyTier {
        NONE(0),
        SMALL(1),
        MEDIUM(2),
        LARGE(3),
        HUGE(4);

        public final int index;

        private GeomancyTier(int i) {
            this.index = i;
        }
    }
}

