/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick;

import com.sargerasarm.noseenotick.NoSeeNoTick;
import com.sargerasarm.noseenotick.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="noseenotick", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static ModConfigSpec CONFIG;
    public static ModConfigSpec.ConfigValue<Integer> maxEntitySpawnDistanceHorizontal;
    public static ModConfigSpec.ConfigValue<Integer> maxEntitySpawnDistanceVertical;
    public static ModConfigSpec.ConfigValue<Integer> maxEntityTickDistanceHorizontal;
    public static ModConfigSpec.ConfigValue<Integer> maxEntityTickDistanceVertical;
    public static ModConfigSpec.ConfigValue<List<String>> entityIgnoreList;
    public static ModConfigSpec.ConfigValue<Integer> minPlayers;
    public static final Set<ResourceLocation> entityResources;
    public static final Set<TagKey<EntityType<?>>> entityTagKeys;
    public static final Set<String> entityWildcards;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent configEvent) {
        Config.updateMobLists();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent configEvent) {
        Config.updateMobLists();
    }

    private static void updateMobLists() {
        Utils.isIgnored.clear();
        for (String key : (List)entityIgnoreList.get()) {
            if (key.contains("#")) continue;
            if (key.contains("*")) {
                entityWildcards.add(key.split(":")[0]);
                continue;
            }
            entityResources.add(ResourceLocation.parse((String)key));
        }
        NoSeeNoTick.LOGGER.debug(entityResources);
        NoSeeNoTick.LOGGER.debug(entityTagKeys);
        NoSeeNoTick.LOGGER.debug(entityWildcards);
    }

    static {
        entityResources = new HashSet<ResourceLocation>();
        entityTagKeys = new HashSet();
        entityWildcards = new HashSet<String>();
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        ArrayList<String> defaultIgnoreList = new ArrayList<String>();
        defaultIgnoreList.add("minecraft:wither");
        defaultIgnoreList.add("minecraft:phantom");
        defaultIgnoreList.add("minecraft:ender_dragon");
        defaultIgnoreList.add("minecraft:elder_guardian");
        defaultIgnoreList.add("minecraft:player");
        defaultIgnoreList.add("alexsmobs:void_worm");
        defaultIgnoreList.add("alexsmobs:void_worm_part");
        defaultIgnoreList.add("alexsmobs:void_worm_shot");
        defaultIgnoreList.add("minecraft:enderman");
        defaultIgnoreList.add("minecraft:creeper");
        defaultIgnoreList.add("minecraft:skeleton");
        defaultIgnoreList.add("minecraft:zombie");
        defaultIgnoreList.add("minecraft:zombie_villager");
        BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        maxEntitySpawnDistanceHorizontal = BUILDER.comment("Maximum distance from player (horizontally) for entity spawning check [Squared, Default 64^2]").define("maxEntitySpawnDistanceHorizontal", (Object)4096);
        maxEntitySpawnDistanceVertical = BUILDER.comment("Maximum distance from player (vertically) for entity spawning check [Raw, Default 32]").define("maxEntitySpawnDistanceVertical", (Object)32);
        maxEntityTickDistanceHorizontal = BUILDER.comment("Maximum distance from player (horizontally) to allow entity ticking [Squared, Default 48^2]").define("maxEntityTickDistanceHorizontal", (Object)2304);
        maxEntityTickDistanceVertical = BUILDER.comment("Maximum distance from player (vertically) to allow entity ticking [Raw, Default 32]").define("maxEntityTickDistanceVertical", (Object)32);
        entityIgnoreList = BUILDER.comment(new String[]{"List of entities to ignore when checking if they are allowed to tick", "Tags can be used by using #minecraft:<tag_name> or #modid:<tag_name>", "You can also use a wildcard after modid (modid:*)", "Example list for a modpack", "entityIgnoreList = [\"minecraft:wither\",\"minecraft:phantom\",\"minecraft:ender_dragon\", \"minecraft:elder_guardian\", \"minecraft:player\", \"botania:*\", \"create:*\", \"ftbic:*\", \"immersiveengineering:*\", \"ae2:*\", \"littlelogistics:*\", \"tiab:*\"]"}).define("entityIgnoreList", defaultIgnoreList);
        minPlayers = BUILDER.comment("Minimum number of players before mod is enabled").define("minPlayers", (Object)2);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

