/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick;

import com.sargerasarm.noseenotick.Config;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static Object2BooleanMap<EntityType<?>> isIgnored = new Object2BooleanOpenHashMap();

    public static boolean isInClaimedChunk(Level level, BlockPos blockPos) {
        return false;
    }

    public static boolean enoughPlayers(Level level) {
        if (level.isClientSide) {
            return false;
        }
        MinecraftServer server = level.getServer();
        if (server != null) {
            return server.getPlayerList().getPlayerCount() >= (Integer)Config.minPlayers.get();
        }
        return false;
    }

    public static boolean isNearPlayer(Level level, BlockPos blockPos, int maxHeight, int maxDistanceSquare) {
        return Utils.isNearPlayerInternal(level, blockPos.getX(), blockPos.getY(), blockPos.getZ(), maxHeight, maxDistanceSquare, false);
    }

    private static boolean isNearPlayerInternal(Level world, double posx, double posy, double posz, int maxHeight, int maxDistanceSquare, boolean allowNullPlayers) {
        List closest = world.players();
        for (Player player : closest) {
            double z;
            double x;
            boolean nearPlayer;
            if (player == null) {
                return allowNullPlayers;
            }
            if (!(Math.abs(player.getY() - posy) < (double)maxHeight) || !(nearPlayer = (x = player.getX() - posx) * x + (z = player.getZ() - posz) * z < (double)maxDistanceSquare)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, Entity entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.getY() - entity.getY()) < (double)maxHeight) {
            double z;
            double x = player.getX() - entity.getX();
            return x * x + (z = player.getZ() - entity.getZ()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(BlockPos player, Vec3 entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)player.getY() - entity.y) < (double)maxHeight) {
            double z;
            double x = (double)player.getX() - entity.x;
            return x * x + (z = (double)player.getZ() - entity.z) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.getY() - cameraY) < (double)maxHeight) {
            double z;
            double x = player.getX() - cameraX;
            return x * x + (z = player.getZ() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isIgnoredEntity(Entity entity) {
        if (((List)Config.entityIgnoreList.get()).isEmpty()) {
            return false;
        }
        EntityType entityType = entity.getType();
        return isIgnored.computeIfAbsent((Object)entityType, et -> {
            ResourceLocation entityRegName = EntityType.getKey((EntityType)entityType);
            if (entityRegName == null) {
                return false;
            }
            boolean ignored = false;
            if (!Config.entityResources.isEmpty()) {
                ignored = Config.entityResources.contains(entityRegName);
            }
            if (!Config.entityWildcards.isEmpty() && !ignored) {
                ignored = Config.entityWildcards.stream().anyMatch(e -> entityRegName.toString().startsWith((String)e));
            }
            if (!Config.entityTagKeys.isEmpty() && !ignored) {
                ignored = Config.entityTagKeys.stream().anyMatch(arg_0 -> ((EntityType)entityType).is(arg_0));
            }
            return ignored;
        });
    }
}

