/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick.client;

import com.sargerasarm.noseenotick.network.ChunkDimPos;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class ClaimedChunksClient {
    private static ClaimedChunksClient instance;
    private final List<ChunkDimPos> claimedChunkList = new ArrayList<ChunkDimPos>();
    private final Object2BooleanMap<ChunkDimPos> claimedCache = new Object2BooleanOpenHashMap();

    public static ClaimedChunksClient getInstance() {
        if (instance == null) {
            instance = new ClaimedChunksClient();
        }
        return instance;
    }

    public List<ChunkDimPos> getClaimedChunks() {
        return this.getClaimedChunks();
    }

    public boolean isChunkClaimed(ChunkDimPos pos) {
        return this.claimedCache.computeIfAbsent((Object)pos, key -> this.claimedChunkList.stream().anyMatch(a -> a.equals(pos)));
    }

    public void removeChunk(ChunkDimPos pos) {
        this.claimedChunkList.remove(pos);
        this.claimedCache.removeBoolean((Object)pos);
    }

    public void addChunk(ChunkDimPos pos) {
        this.claimedChunkList.add(pos);
        this.claimedCache.put((Object)pos, true);
    }

    public void updateChunks(List<ChunkDimPos> chunks) {
        this.claimedChunkList.clear();
        this.claimedCache.clear();
        this.claimedChunkList.addAll(chunks);
    }
}

