/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sargerasarm.noseenotick.Utils;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemEntity {
    private static final Cache<UUID, Boolean> itemCollisionCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(1L)).build();

    public static boolean isGrounded(Level level, Entity entity, AABB aabb) {
        if (entity.onGround() && Utils.enoughPlayers(level)) {
            try {
                return (Boolean)itemCollisionCache.get((Object)entity.getUUID(), () -> ItemEntity.noCollision(level, entity, aabb));
            }
            catch (ExecutionException e) {
                itemCollisionCache.invalidate((Object)entity.getUUID());
                return false;
            }
        }
        return ItemEntity.noCollision(level, entity, aabb);
    }

    private static boolean noCollision(Level level, Entity entity, AABB aabb) {
        for (VoxelShape voxelShape : level.getBlockCollisions(entity, aabb)) {
            if (voxelShape.isEmpty()) continue;
            return false;
        }
        if (!level.getEntityCollisions(entity, aabb).isEmpty()) {
            return false;
        }
        if (entity != null) {
            WorldBorder worldBorder = level.getWorldBorder();
            VoxelShape borderCollision = worldBorder.isInsideCloseToBorder(entity, aabb) ? worldBorder.getCollisionShape() : null;
            return borderCollision == null || !Shapes.joinIsNotEmpty((VoxelShape)borderCollision, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.AND);
        }
        return true;
    }
}

