/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.sargerasarm.noseenotick.Config;
import com.sargerasarm.noseenotick.Utils;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.timings.TimeTracker;

public class TickOptimizer {
    public static void entityTicking(Consumer<Entity> consumer, Entity entity, Level level, RandomSource random) {
        int maxDistanceSquare;
        if (!Utils.enoughPlayers(level)) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        if (Utils.isIgnoredEntity(entity)) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        BlockPos entityPos = entity.blockPosition();
        boolean isInClaimedChunk = Utils.isInClaimedChunk(level, entityPos);
        if (!(entity instanceof LivingEntity) || entity instanceof Player) {
            if (!isInClaimedChunk && entity instanceof ItemEntity && random.nextInt(4) == 0) {
                return;
            }
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        int maxHeight = (Integer)Config.maxEntityTickDistanceVertical.get();
        if (Utils.isNearPlayer(level, entityPos, maxHeight, maxDistanceSquare = ((Integer)Config.maxEntityTickDistanceHorizontal.get()).intValue())) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        if (isInClaimedChunk || ((LivingEntity)entity).isDeadOrDying()) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
        }
    }

    public static void handleGuardEntityTick(Consumer<Entity> consumer, Entity entity) {
        try {
            TimeTracker.ENTITY_UPDATE.trackStart((Object)entity);
            consumer.accept(entity);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Ticking entity");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being ticked");
            entity.fillCrashReportCategory(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        finally {
            TimeTracker.ENTITY_UPDATE.trackEnd((Object)entity);
        }
    }
}

