/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.spirit;

import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetManagedMachine;
import com.klikli_dev.occultism.util.EnumUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.StringUtils;

public class BookOfCallingManagedMachineGui
extends Screen {
    protected final String originalCustomName;
    protected String customName;
    protected Direction insertFacing = Direction.UP;
    protected Direction extractFacing = Direction.DOWN;
    protected EditBox text;

    public BookOfCallingManagedMachineGui(Direction insertFacing, Direction extractFacing, String customName) {
        super((Component)Component.literal((String)""));
        this.insertFacing = insertFacing;
        this.extractFacing = extractFacing;
        this.customName = customName == null ? "" : customName;
        this.originalCustomName = this.customName;
        this.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.text.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        super.onClose();
        this.text.setFocused(false);
        if (!StringUtils.isBlank((CharSequence)this.customName) && !this.customName.equals(this.originalCustomName)) {
            Networking.sendToServer(new MessageSetManagedMachine(this.makeMachineReference()));
        }
    }

    public void init() {
        super.init();
        this.clearWidgets();
        int guiLeft = this.width / 2;
        int guiTop = (this.height - 166) / 2;
        int buttonWidth = 150;
        int buttonMargin = 5;
        int buttonHeight = 20;
        int buttonTop = 60;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(guiLeft - buttonWidth / 2, guiTop + buttonTop, buttonWidth, buttonHeight, (Component)Component.translatable((String)("enum.occultism.facing." + this.insertFacing.getSerializedName())), b -> {
            MachineReference reference = this.makeMachineReference();
            this.insertFacing = reference.insertFacing = EnumUtil.nextFacing(this.insertFacing);
            Networking.sendToServer(new MessageSetManagedMachine(reference));
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(guiLeft - buttonWidth / 2, guiTop + buttonTop + buttonHeight + buttonMargin, buttonWidth, buttonHeight, (Component)Component.translatable((String)("enum.occultism.facing." + this.extractFacing.getSerializedName())), b -> {
            MachineReference reference = this.makeMachineReference();
            this.extractFacing = reference.extractFacing = EnumUtil.nextFacing(this.extractFacing);
            Networking.sendToServer(new MessageSetManagedMachine(reference));
            this.init();
        }));
        int textWidth = buttonWidth - 4;
        this.text = new EditBox(this.font, guiLeft - textWidth / 2, guiTop + buttonTop + buttonHeight * 2 + buttonMargin * 2, textWidth, buttonHeight, (Component)Component.literal((String)""));
        this.text.setMaxLength(30);
        this.text.setVisible(true);
        this.text.setTextColor(0xFFFFFF);
        this.text.setFocused(true);
        this.text.setValue(this.customName);
        int exitButtonSize = 20;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(guiLeft - exitButtonSize / 2, guiTop + buttonTop + buttonHeight * 3 + buttonMargin * 3, exitButtonSize, exitButtonSize, (Component)Component.literal((String)"X"), b -> this.onClose()));
        LabelWidget insertFacingLabel = new LabelWidget(guiLeft - 80, guiTop + (buttonTop += 5), false, -1, 2, 0xFFFFFF).alignRight(true);
        insertFacingLabel.addLine("gui.occultism.book_of_calling.manage_machine.insert", true);
        this.addRenderableWidget((GuiEventListener)insertFacingLabel);
        LabelWidget extractFacingLabel = new LabelWidget(guiLeft - 80, guiTop + buttonTop + buttonHeight + buttonMargin, false, -1, 2, 0xFFFFFF).alignRight(true);
        extractFacingLabel.addLine("gui.occultism.book_of_calling.manage_machine.extract", true);
        this.addRenderableWidget((GuiEventListener)extractFacingLabel);
        LabelWidget customNameLabel = new LabelWidget(guiLeft - 80, guiTop + buttonTop + buttonHeight * 2 + buttonMargin * 2 + 1, false, -1, 2, 0xFFFFFF).alignRight(true);
        customNameLabel.addLine("gui.occultism.book_of_calling.manage_machine.custom_name", true);
        this.addRenderableWidget((GuiEventListener)customNameLabel);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.text.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (this.text.keyPressed(keyCode, scanCode, p_keyPressed_3_)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.text.charTyped(typedChar, keyCode)) {
            this.customName = this.text.getValue();
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public MachineReference makeMachineReference() {
        return new MachineReference((GlobalBlockPos)null, null, false, this.extractFacing, (GlobalBlockPos)null, null, false, this.insertFacing, this.customName);
    }
}

