/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.occultism.common.block.EntityWormholeBlock;
import com.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="occultism")
public class EntityWormholeBlockEntity
extends NetworkedBlockEntity {
    public long lastChangeTime;
    public ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            Level level = EntityWormholeBlockEntity.this.level;
            if (level != null && !level.isClientSide) {
                EntityWormholeBlockEntity.this.lastChangeTime = level.getGameTime();
                EntityWormholeBlockEntity.this.setChanged();
                EntityWormholeBlockEntity.this.markNetworkDirty();
            }
        }
    };
    protected boolean initialized = false;

    public EntityWormholeBlockEntity(BlockPos worldPos, BlockState state) {
        super(OccultismBlockEntities.ENTITY_WORMHOLE.get(), worldPos, state);
        this.itemStackHandler = new ItemStackHandler(1){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack.is(ItemTags.COMPASSES) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                if (EntityWormholeBlockEntity.this.level != null && !((EntityWormholeBlockEntity)EntityWormholeBlockEntity.this).level.isClientSide) {
                    EntityWormholeBlockEntity.this.lastChangeTime = EntityWormholeBlockEntity.this.level.getGameTime();
                    EntityWormholeBlockEntity.this.markNetworkDirty();
                }
            }
        };
    }

    public EntityWormholeBlockEntity(BlockEntityType<?> BlockEntityTypeIn, BlockPos worldPos, BlockState state) {
        super(BlockEntityTypeIn, worldPos, state);
    }

    @Override
    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        this.itemStackHandler.deserializeNBT(provider, compound.getCompound("inventory"));
        this.lastChangeTime = compound.getLong("lastChangeTime");
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("inventory", (Tag)this.itemStackHandler.serializeNBT(provider));
        compound.putLong("lastChangeTime", this.lastChangeTime);
        return compound;
    }

    @SubscribeEvent
    public static void entityWormholeFishing(PlayerInteractEvent.RightClickItem event) {
        BlockState state;
        Block block;
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        FishingHook hook = player.fishing;
        if (!event.isCanceled() && !event.getLevel().isClientSide() && stack.getItem() instanceof FishingRodItem && hook != null && hook.getHookedIn() == null && hook.getDeltaMovement().equals((Object)Vec3.ZERO) && (block = (state = event.getLevel().getBlockState(hook.blockPosition())).getBlock()) instanceof EntityWormholeBlock) {
            EntityWormholeBlock wormhole = (EntityWormholeBlock)block;
            wormhole.pullEntity((ServerLevel)event.getLevel(), hook.blockPosition(), state);
        }
    }
}

