/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.ai.goal.PausableGoal;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FallbackDepositToControllerGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected ManageMachineJob job;
    protected int retries = 0;

    public FallbackDepositToControllerGoal(SpiritEntity entity, ManageMachineJob job) {
        this.entity = entity;
        this.job = job;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean canUse() {
        if (this.entity.getTarget() != null) {
            return false;
        }
        if (this.job.getStorageController() == null) {
            return false;
        }
        return !this.isPaused() && !this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.entity.getDepositPosition().isPresent();
    }

    @Override
    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        BlockEntity storageProxy = this.findClosestStorageProxy();
        if (storageProxy != null) {
            this.entity.setDepositPosition(storageProxy.getBlockPos());
            this.entity.setDepositFacing(Direction.UP);
        } else {
            if (this.retries <= 60) {
                ++this.retries;
            }
            this.pause((long)this.retries * 10000L);
        }
    }

    protected BlockEntity findClosestStorageProxy() {
        Level level = this.entity.level();
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        if (this.job.getManagedMachine() == null || this.job.getManagedMachine().insertGlobalPos == null) {
            return null;
        }
        BlockPos machinePosition = this.job.getManagedMachine().insertGlobalPos.getPos();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        List searchBlocks = BlockPos.betweenClosedStream((BlockPos)machinePosition.offset(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)machinePosition.offset(workAreaSize, workAreaSize / 2, workAreaSize)).map(BlockPos::immutable).collect(Collectors.toList());
        for (BlockPos pos : searchBlocks) {
            IStorageControllerProxy proxy;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof IStorageControllerProxy) || (proxy = (IStorageControllerProxy)blockEntity).getLinkedStorageControllerPosition() == null || !proxy.getLinkedStorageControllerPosition().equals(this.job.getStorageControllerPosition())) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            return level.getBlockEntity((BlockPos)allBlocks.get(0));
        }
        return null;
    }
}

