/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import net.minecraft.world.entity.ai.goal.Goal;

public abstract class PausableGoal
extends Goal {
    protected long lastPaused;
    protected long pauseDuration;

    public boolean isPaused() {
        long currentTime = System.currentTimeMillis();
        return this.lastPaused + this.pauseDuration > currentTime;
    }

    public boolean canUse() {
        return !this.isPaused();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !this.isPaused();
    }

    public void pause(long i) {
        this.pauseDuration = i;
        this.lastPaused = System.currentTimeMillis();
    }

    public void unpause() {
        this.pauseDuration = 0L;
    }
}

