/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.neoforge;

import com.blackgear.platform.client.GameRendering;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

public class GameRenderingImpl {
    public static void registerBlockColors(Consumer<GameRendering.BlockColorEvent> listener) {
        final IEventBus bus = ModLoadingContext.get().getActiveContainer().getEventBus();
        GameRendering.BlockColorEvent colorEvent = new GameRendering.BlockColorEvent(){

            @Override
            public void register(ItemColor color, ItemLike ... items) {
                bus.addListener(event -> event.register(color, items));
            }

            @Override
            public void register(BlockColor color, Block ... blocks) {
                bus.addListener(event -> event.register(color, blocks));
            }
        };
        listener.accept(colorEvent);
    }

    public static void registerBlockRenderers(Consumer<GameRendering.BlockRendererEvent> listener) {
        listener.accept(new GameRendering.BlockRendererEvent(){

            @Override
            public void register(RenderType type, Block ... blocks) {
                Arrays.stream(blocks).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type));
            }

            @Override
            public void register(RenderType type, Fluid ... fluids) {
                Arrays.stream(fluids).forEach(fluid -> ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type));
            }
        });
    }

    public static void registerEntityRenderers(Consumer<GameRendering.EntityRendererEvent> listener) {
        Consumer<EntityRenderersEvent.RegisterRenderers> consumer = event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(consumer);
    }

    public static void registerBlockEntityRenderers(Consumer<GameRendering.BlockEntityRendererEvent> listener) {
        Consumer<EntityRenderersEvent.RegisterRenderers> consumer = event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(consumer);
    }

    public static void registerModelLayers(Consumer<GameRendering.ModelLayerEvent> listener) {
        Consumer<EntityRenderersEvent.RegisterLayerDefinitions> consumer = event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(consumer);
    }

    public static void registerSpecialModels(Consumer<GameRendering.SpecialModelEvent> listener) {
        Consumer<ModelEvent.RegisterAdditional> consumer = event -> {
            GameRendering.SpecialModelEvent modelEvent = new GameRendering.SpecialModelEvent((ModelEvent.RegisterAdditional)event){
                final /* synthetic */ ModelEvent.RegisterAdditional val$event;
                {
                    this.val$event = registerAdditional;
                }

                @Override
                public void register(ResourceLocation model) {
                    ResourceLocation wrapped = ResourceLocation.fromNamespaceAndPath((String)model.getNamespace(), (String)("item/" + model.getPath()));
                    this.val$event.register(new ModelResourceLocation(wrapped, "standalone"));
                }

                @Override
                public void register(ResourceLocation ... models) {
                    Arrays.stream(models).forEach(this::register);
                }
            };
            listener.accept(modelEvent);
        };
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(consumer);
    }

    public static void registerSkullRenderers(Consumer<GameRendering.SkullRendererEvent> listener) {
        Consumer<EntityRenderersEvent.CreateSkullModels> consumer = event -> {
            GameRendering.SkullRendererEvent skullEvent = new GameRendering.SkullRendererEvent((EntityRenderersEvent.CreateSkullModels)event){
                final /* synthetic */ EntityRenderersEvent.CreateSkullModels val$event;
                {
                    this.val$event = createSkullModels;
                }

                @Override
                public void registerSkullModel(SkullBlock.Type type, Function<ModelPart, SkullModelBase> model, ModelLayerLocation layer) {
                    this.val$event.registerSkullModel(type, model.apply(this.val$event.getEntityModelSet().bakeLayer(layer)));
                }

                @Override
                public void registerSkullTexture(SkullBlock.Type type, ResourceLocation texture) {
                    SkullBlockRenderer.SKIN_BY_TYPE.put(type, texture);
                }
            };
            listener.accept(skullEvent);
        };
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(consumer);
    }

    public static void registerParticleFactories(Consumer<GameRendering.ParticleFactoryEvent> listener) {
        Consumer<RegisterParticleProvidersEvent> consumer = event -> {
            GameRendering.ParticleFactoryEvent factoryEvent = new GameRendering.ParticleFactoryEvent((RegisterParticleProvidersEvent)event){
                final /* synthetic */ RegisterParticleProvidersEvent val$event;
                {
                    this.val$event = registerParticleProvidersEvent;
                }

                @Override
                public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> type, ParticleProvider<T> provider) {
                    this.val$event.registerSpecial((ParticleType)type.get(), provider);
                }

                @Override
                public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> type, GameRendering.ParticleFactoryEvent.Factory<T> factory) {
                    this.val$event.registerSpriteSet((ParticleType)type.get(), factory::create);
                }
            };
            listener.accept(factoryEvent);
        };
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(consumer);
    }
}

