/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.events;

import com.blackgear.platform.core.util.event.Event;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface EntityEvents {
    public static final Event<LivingSpawn> ON_SPAWN = Event.create(LivingSpawn.class, events -> (entity, level) -> Arrays.stream(events).allMatch(event -> event.onSpawn(entity, level)));
    public static final Event<LivingAttack> ON_ATTACK = Event.create(LivingAttack.class, events -> (entity, source) -> Arrays.stream(events).allMatch(event -> event.onAttack(entity, source)));
    public static final Event<LivingDeath> ON_DEATH = Event.create(LivingDeath.class, events -> (entity, source) -> Arrays.stream(events).allMatch(event -> event.onDeath(entity, source)));
    public static final Event<EntityPickUp> ON_PICK = Event.create(EntityPickUp.class);

    public static interface LivingDeath {
        public boolean onDeath(Entity var1, DamageSource var2);
    }

    public static interface LivingAttack {
        public boolean onAttack(Entity var1, DamageSource var2);
    }

    public static interface LivingSpawn {
        public boolean onSpawn(Entity var1, Level var2);
    }

    public static interface EntityPickUp {
        public void onPickUp(Entity var1, Consumer<ItemStack> var2);
    }
}

