/*
 * Decompiled with CFR 0.152.
 */
package net.subthy.plushie_buddies.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.subthy.plushie_buddies.sound.ModSounds;

public class Plushie
extends HorizontalDirectionalBlock
implements Equipable {
    public static final VoxelShape SHAPE_N = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_W = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_S = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_E = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public Plushie(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Plushie.getVoxelShape(pState, FACING, SHAPE_N, SHAPE_S, SHAPE_W, SHAPE_E);
    }

    static VoxelShape getVoxelShape(BlockState pState, DirectionProperty facing, VoxelShape shapeN, VoxelShape shapeS, VoxelShape shapeW, VoxelShape shapeE) {
        return switch ((Direction)pState.getValue((Property)facing)) {
            case Direction.SOUTH -> shapeS;
            case Direction.WEST -> shapeW;
            case Direction.EAST -> shapeE;
            default -> shapeN;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide()) {
            level.playSound(null, pos, ModSounds.Plushie_Sound.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

