/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.potionicons;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeUtils;
import com.samsthenerd.potionicons.PotionIconsMod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.NotNull;

public class EffectDataTTProvider
implements CustomTooltipManager.CustomTooltipProvider<Holder<MobEffect>> {
    public static final EffectDataTTProvider INSTANCE = new EffectDataTTProvider();
    public static List<UnaryOperator<String>> EFFECT_DESCRIBERS = List.of(id -> id + ".description", id -> id + ".desc", id -> "description." + id);

    public ResourceLocation getId() {
        return PotionIconsMod.id("effectdata");
    }

    @NotNull
    public List<Component> getTooltipText(Holder<MobEffect> effectEntry) {
        MobEffect effect = (MobEffect)effectEntry.value();
        ArrayList<Component> effectInfo = new ArrayList<Component>();
        MutableComponent title = Component.translatable((String)effect.getDescriptionId()).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        String effectLangKey = null;
        for (UnaryOperator<String> descrr : EFFECT_DESCRIBERS) {
            String effKey = (String)descrr.apply(effect.getDescriptionId());
            if (!I18n.exists((String)effKey)) continue;
            effectLangKey = effKey;
            break;
        }
        effectInfo.add((Component)title);
        if (effectLangKey != null) {
            MutableComponent description = Component.translatable(effectLangKey).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
            effectInfo.add((Component)description);
        }
        return effectInfo;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipData(Holder<MobEffect> effectEntry) {
        MobEffect effect = (MobEffect)effectEntry.value();
        TextureAtlasSprite effectSprite = Minecraft.getInstance().getMobEffectTextures().get(effectEntry);
        Spritelike effectSpritelike = SpritelikeUtils.spritelikeFromSprite((TextureAtlasSprite)effectSprite);
        return Optional.of(new SpriteTooltipData(effectSpritelike, (w, h) -> 32));
    }

    @NotNull
    public Codec<Holder<MobEffect>> getCodec() {
        return MobEffect.CODEC;
    }
}

