/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.potionicons;

import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.client.extrahooks.ItemOverlayRenderer;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.potionicons.EffectInlineData;
import com.samsthenerd.potionicons.EffectInlineRenderer;
import com.samsthenerd.potionicons.PotionIconsConfig;
import com.samsthenerd.potionicons.PotionIconsMod;
import com.samsthenerd.potionicons.PotionOverlayRenderer;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;

public class PotionIconsModClient {
    public static void init() {
        PotionIconsMod.isClient = true;
        AutoConfig.register(PotionIconsConfig.class, Toml4jConfigSerializer::new);
        ItemOverlayRenderer.addRenderer((ItemOverlayRenderer)PotionOverlayRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer((InlineRenderer)EffectInlineRenderer.INSTANCE);
        ResourceLocation effectMatcherID = PotionIconsMod.id("effect");
        InlineClientAPI.INSTANCE.addMatcher((InlineMatcher)new RegexMatcher.Standard("effect", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, effectMatcherID, effectId -> {
            ResourceLocation effActualId = ResourceLocation.parse((String)effectId.toLowerCase());
            Optional optEff = BuiltInRegistries.MOB_EFFECT.getHolder(effActualId);
            if (optEff.isEmpty()) {
                return null;
            }
            Holder.Reference effect = (Holder.Reference)optEff.get();
            EffectInlineData effData = new EffectInlineData((Holder<MobEffect>)effect);
            return new InlineMatch.DataMatch((InlineData)effData, effData.getExtraStyle());
        }, MatcherInfo.fromId((ResourceLocation)effectMatcherID)));
        ResourceLocation potionMatcherID = PotionIconsMod.id("potion");
        InlineClientAPI.INSTANCE.addMatcher((InlineMatcher)new RegexMatcher.Standard("potion", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, potionMatcherID, potionId -> {
            ResourceLocation potActualId = ResourceLocation.parse((String)potionId.toLowerCase());
            Optional optPot = BuiltInRegistries.POTION.getHolder(potActualId);
            if (optPot.isEmpty()) {
                return null;
            }
            Holder.Reference potion = (Holder.Reference)optPot.get();
            ItemStack potStack = Items.POTION.getDefaultInstance();
            potStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)potion));
            HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(potStack));
            ItemInlineData itemData = new ItemInlineData(potStack);
            return new InlineMatch.DataMatch((InlineData)itemData, Style.EMPTY.withHoverEvent(hover));
        }, MatcherInfo.fromId((ResourceLocation)potionMatcherID)));
    }

    public static PotionIconsConfig getConfig() {
        return (PotionIconsConfig)AutoConfig.getConfigHolder(PotionIconsConfig.class).getConfig();
    }
}

