/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.potionicons;

import com.samsthenerd.inline.api.client.extrahooks.ItemOverlayRenderer;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import com.samsthenerd.inline.utils.SpritelikeUtils;
import com.samsthenerd.potionicons.PotionIconsConfig;
import com.samsthenerd.potionicons.PotionIconsModClient;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public class PotionOverlayRenderer
implements ItemOverlayRenderer {
    public static PotionOverlayRenderer INSTANCE = new PotionOverlayRenderer();

    public void render(ItemStack stack, GuiGraphics drawContext) {
        PotionIconsConfig.PIRenderMode mode;
        PotionContents potComp = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potComp == null) {
            return;
        }
        Iterable effects = potComp.getAllEffects();
        boolean isShift = Screen.hasShiftDown();
        PotionIconsConfig config = PotionIconsModClient.getConfig();
        PotionIconsConfig.PIRenderMode pIRenderMode = mode = isShift ? config.shiftMode : config.normalMode;
        if (mode == PotionIconsConfig.PIRenderMode.NONE) {
            return;
        }
        int i = 0;
        ArrayList<MobEffectInstance> effectsList = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : effects) {
            effectsList.add(effect);
        }
        double cycleSpeed = isShift ? config.cycleSpeedShift : config.cycleSpeedNormal;
        long cycleSpeedMS = Math.round(cycleSpeed * 1000.0);
        long startIdx = 0L;
        if (cycleSpeedMS != 0L) {
            startIdx = SpriteUVLens.getSysTime() / cycleSpeedMS % (long)effectsList.size();
        }
        int j = 0;
        while ((long)j < startIdx) {
            effectsList.add((MobEffectInstance)effectsList.removeFirst());
            ++j;
        }
        for (MobEffectInstance effect : effectsList) {
            TextureAtlasSprite effectSprite = Minecraft.getInstance().getMobEffectTextures().get(effect.getEffect());
            Spritelike effectSpritelike = SpritelikeUtils.spritelikeFromSprite((TextureAtlasSprite)effectSprite);
            if (mode == PotionIconsConfig.PIRenderMode.FULL) {
                SpritelikeRenderers.getRenderer((Spritelike)effectSpritelike).drawSprite(effectSpritelike, drawContext, -1.0f, -1.0f, (float)(effectsList.size() - i), 18.0f, 18.0f);
            } else if (mode == PotionIconsConfig.PIRenderMode.TOP_LEFT || mode == PotionIconsConfig.PIRenderMode.TRY_BOTTOM_RIGHT && stack.getMaxStackSize() > 1) {
                SpritelikeRenderers.getRenderer((Spritelike)effectSpritelike).drawSprite(effectSpritelike, drawContext, (float)(2 * i), (float)(2 * i), (float)(effectsList.size() - i), 9.0f, 9.0f);
            } else if (mode == PotionIconsConfig.PIRenderMode.TRY_BOTTOM_RIGHT) {
                SpritelikeRenderers.getRenderer((Spritelike)effectSpritelike).drawSprite(effectSpritelike, drawContext, (float)(7 - 2 * i), (float)(7 - 2 * i), (float)(effectsList.size() - i), 9.0f, 9.0f);
            }
            ++i;
        }
    }

    public boolean renderInFront(ItemStack stack) {
        boolean isShift = Screen.hasShiftDown();
        PotionIconsConfig config = PotionIconsModClient.getConfig();
        return isShift ? config.shiftFront : config.normalFront;
    }

    public boolean isActive(ItemStack stack) {
        return stack.get(DataComponents.POTION_CONTENTS) != null;
    }
}

