/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.control.parameters;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.StringUtils;

public class BlockSide
implements Comparable<BlockSide> {
    @Nullable
    private final String nodeName;
    @Nullable
    private final Direction side;
    private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    public static final Codec<BlockSide> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("node").forGetter(side -> Optional.ofNullable(side.getNodeName())), (App)Direction.CODEC.optionalFieldOf("side").forGetter(side -> Optional.ofNullable(side.getSide()))).apply((Applicative)instance, (node, dir) -> new BlockSide(node.orElse(null), dir.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockSide> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), inv -> Optional.ofNullable(inv.getNodeName()), (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), inv -> Optional.ofNullable(inv.getSide()), (node, side) -> new BlockSide(node.orElse(null), side.orElse(null)));

    public BlockSide(@Nullable String name, @Nullable Direction side) {
        this.nodeName = name == null || name.isEmpty() ? null : name;
        this.side = side;
    }

    @Override
    public int compareTo(@Nonnull BlockSide blockSide) {
        if (this.nodeName == null && blockSide.nodeName != null) {
            return -1;
        }
        if (this.nodeName != null && blockSide.nodeName == null) {
            return 1;
        }
        if (this.nodeName == null) {
            return 0;
        }
        return this.nodeName.compareTo(blockSide.nodeName);
    }

    @Nullable
    public String getNodeName() {
        return this.nodeName;
    }

    @Nonnull
    public String getNodeNameSafe() {
        return this.nodeName == null ? "" : this.nodeName;
    }

    public boolean hasNodeName() {
        return this.nodeName != null && !this.nodeName.isEmpty();
    }

    @Nullable
    public Direction getSide() {
        return this.side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockSide blockSide = (BlockSide)o;
        if (this.nodeName != null ? !this.nodeName.equals(blockSide.nodeName) : blockSide.nodeName != null) {
            return false;
        }
        return this.side == blockSide.side;
    }

    public int hashCode() {
        int result = this.nodeName != null ? this.nodeName.hashCode() : 0;
        result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.side == null) {
            return "*";
        }
        return this.side.toString();
    }

    public String getStringRepresentation() {
        String s;
        Direction facing = this.getSide();
        String string = s = facing == null ? "" : StringUtils.left((String)facing.getSerializedName().toUpperCase(), (int)1);
        if (this.getNodeName() == null) {
            return s;
        }
        return StringUtils.left((String)this.getNodeName(), (int)7) + " " + s;
    }
}

