/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.control.parameters;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterSerializerHelpers;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class Parameter
implements IParameter {
    private final ParameterType parameterType;
    private final ParameterValue parameterValue;
    private static final int MODE_FUNCTION = 2;
    private static final int MODE_VARIABLE = 1;
    private static final int MODE_CONSTANT = 0;
    public static final Codec<Parameter> CODEC = new Codec<Parameter>(){

        public <T> DataResult<T> encode(Parameter input, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            return ParameterType.CODEC.encodeStart(ops, (Object)input.getParameterType()).flatMap(typeElement -> {
                builder.add("type", typeElement);
                ParameterValue parameterValue = input.getParameterValue();
                if (parameterValue == null) {
                    return DataResult.error(() -> "Parameter value is missing");
                }
                if (parameterValue.isVariable()) {
                    builder.add("variable", ops.createInt(parameterValue.getVariableIndex()));
                    return builder.build(prefix);
                }
                if (parameterValue.isFunction()) {
                    builder.add("function", ops.createString(parameterValue.getFunction().getId()));
                    return builder.build(prefix);
                }
                Object constant = parameterValue.getValue();
                if (constant == null) {
                    return builder.build(prefix);
                }
                return ParameterSerializerHelpers.encodeConstant(ops, input.getParameterType(), constant).flatMap(valueElement -> {
                    builder.add("value", valueElement);
                    return builder.build(prefix);
                });
            });
        }

        public <T> DataResult<Pair<Parameter, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(mapLike -> {
                Object typeElement = mapLike.get("type");
                if (typeElement == null) {
                    return DataResult.error(() -> "Missing parameter type");
                }
                return ParameterType.CODEC.parse(ops, typeElement).flatMap(type -> {
                    Object variableElement = mapLike.get("variable");
                    if (variableElement != null) {
                        return ops.getNumberValue(variableElement).map(Number::intValue).map(index -> Pair.of((Object)new Parameter((ParameterType)((Object)((Object)type)), ParameterValue.variable(index)), (Object)ops.empty())).mapError(error -> "Invalid variable index: " + error);
                    }
                    Object functionElement = mapLike.get("function");
                    if (functionElement != null) {
                        return ops.getStringValue(functionElement).flatMap(id -> {
                            Function function = ParameterSerializerHelpers.resolveFunction(id);
                            if (function == null) {
                                return DataResult.error(() -> "Unknown parameter function: " + id);
                            }
                            return DataResult.success((Object)Pair.of((Object)new Parameter((ParameterType)((Object)((Object)type)), ParameterValue.function(function)), (Object)ops.empty()));
                        }).mapError(error -> "Invalid function id: " + error);
                    }
                    Object valueElement = mapLike.get("value");
                    if (valueElement == null) {
                        return DataResult.success((Object)Pair.of((Object)new Parameter((ParameterType)((Object)((Object)type)), ParameterValue.constant(null)), (Object)ops.empty()));
                    }
                    return ParameterSerializerHelpers.decodeConstant(ops, type, valueElement).flatMap(constant -> DataResult.success((Object)Pair.of((Object)new Parameter((ParameterType)((Object)((Object)type)), ParameterValue.constant(constant)), (Object)ops.empty())));
                });
            });
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, Parameter> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Parameter>(){

        public Parameter decode(RegistryFriendlyByteBuf buf) {
            ParameterType type = (ParameterType)((Object)ParameterType.STREAM_CODEC.decode((Object)buf));
            byte mode = buf.readByte();
            return switch (mode) {
                case 1 -> new Parameter(type, ParameterValue.variable(buf.readVarInt()));
                case 2 -> {
                    String id = buf.readUtf();
                    Function function = ParameterSerializerHelpers.resolveFunction(id);
                    if (function == null) {
                        throw new IllegalStateException("Unknown parameter function: " + id);
                    }
                    yield new Parameter(type, ParameterValue.function(function));
                }
                case 0 -> {
                    boolean hasValue = buf.readBoolean();
                    Object value = hasValue ? ParameterSerializerHelpers.requireSerializer(type).decodeFromNetwork(buf) : null;
                    yield new Parameter(type, ParameterValue.constant(value));
                }
                default -> throw new IllegalStateException("Unsupported parameter value mode: " + mode);
            };
        }

        public void encode(RegistryFriendlyByteBuf buf, Parameter input) {
            ParameterType.STREAM_CODEC.encode((Object)buf, (Object)input.getParameterType());
            ParameterValue parameterValue = input.getParameterValue();
            if (parameterValue.isVariable()) {
                buf.writeByte(1);
                buf.writeVarInt(parameterValue.getVariableIndex());
            } else if (parameterValue.isFunction()) {
                buf.writeByte(2);
                buf.writeUtf(parameterValue.getFunction().getId());
            } else {
                buf.writeByte(0);
                Object constant = parameterValue.getValue();
                if (constant == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    ParameterType type = input.getParameterType();
                    ParameterSerializerHelpers.requireSerializer(type).encodeToNetwork(buf, constant);
                }
            }
        }
    };

    private Parameter(ParameterType parameterType, ParameterValue parameterValue) {
        this.parameterType = parameterType;
        this.parameterValue = parameterValue;
    }

    private Parameter(Builder builder) {
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IParameter parameter = (IParameter)o;
        return this.parameterType == parameter.getParameterType() && Objects.equals(this.parameterValue, parameter.getParameterValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parameterType, this.parameterValue});
    }

    @Override
    public boolean isSet() {
        return this.parameterValue != null && this.parameterValue.getValue() != null;
    }

    @Override
    public ParameterType getParameterType() {
        return this.parameterType;
    }

    @Override
    public ParameterValue getParameterValue() {
        return this.parameterValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ParameterType parameterType;
        private ParameterValue parameterValue;

        public Builder type(ParameterType parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public Builder value(ParameterValue value) {
            this.parameterValue = value;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }
}

