/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.neoforge.mixin;

import io.github.mortuusars.scholar.client.resource.BuiltInResourcePacks;
import io.github.mortuusars.scholar.neoforge.resource.ProcessedBuiltInResourcePackTracker;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Options.class})
public class OptionsMixin {
    @Shadow
    public List<String> resourcePacks;

    @Inject(method={"load(Z)V"}, at={@At(value="RETURN")}, remap=false)
    private void onLoad(boolean limited, CallbackInfo ci) {
        if (limited) {
            return;
        }
        Set<String> processedPacks = ProcessedBuiltInResourcePackTracker.getPacks();
        LinkedHashSet<String> resourcePacks = new LinkedHashSet<String>(this.resourcePacks);
        List<BuiltInResourcePacks.Pack> packs = BuiltInResourcePacks.get();
        for (BuiltInResourcePacks.Pack pack2 : packs) {
            String id = pack2.id().toString();
            if (pack2.activation().neoforge() == BuiltInResourcePacks.ActivationType.DEFAULT_ENABLED) {
                if (!processedPacks.add(id)) continue;
                resourcePacks.add(id);
                continue;
            }
            processedPacks.remove(id);
        }
        processedPacks.removeIf(pack -> packs.stream().noneMatch(p -> p.id().toString().equals(pack)));
        ProcessedBuiltInResourcePackTracker.savePacks(processedPacks);
        this.resourcePacks = new ArrayList<String>(resourcePacks);
    }
}

