/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.util;

import java.util.function.Supplier;

public interface Change {
    public void apply();

    public boolean undo();

    public static Change create(final Runnable apply, final Supplier<Boolean> undo) {
        return new Change(){

            @Override
            public void apply() {
                apply.run();
            }

            @Override
            public boolean undo() {
                return (Boolean)undo.get();
            }
        };
    }

    public static Change create(Runnable apply, Runnable undo) {
        return Change.create(apply, () -> {
            undo.run();
            return true;
        });
    }
}

