/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum RepeatMode implements StringRepresentable
{
    ALL("all"),
    ONE("one"),
    NO("no");

    public static final Codec<RepeatMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, RepeatMode> STREAM_CODEC;
    private final String name;
    private static final Map<String, RepeatMode> NAME_VALUES;
    private static final RepeatMode[] VALUES;

    private RepeatMode(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public RepeatMode next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static RepeatMode fromName(String name) {
        return NAME_VALUES.getOrDefault(name, NO);
    }

    static {
        CODEC = StringRepresentable.fromEnum(RepeatMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(RepeatMode.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RepeatMode value : RepeatMode.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = RepeatMode.values();
    }
}

