/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.client.render;

import com.chadate.spellelemental.client.network.custom.ClientPayloadHandler;
import com.chadate.spellelemental.data.ElementContainerAttachment;
import com.chadate.spellelemental.data.SpellAttachments;
import com.chadate.spellelemental.element.attachment.data.UnifiedElementAttachmentAssets;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

@EventBusSubscriber(modid="spellelemental", value={Dist.CLIENT})
public class ElementAuraRenderer {
    private static final Random RNG = new Random();

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<LivingEntity, ?> event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        Map<String, Integer> snapshot = ((ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER)).snapshot();
        if (snapshot.isEmpty()) {
            return;
        }
        for (String elementKey : snapshot.keySet()) {
            SimpleParticleType simple;
            String particleKey;
            int remain = ClientPayloadHandler.DisplayCache.predictRemaining(entity.getId(), elementKey);
            if (remain == 0 || (particleKey = UnifiedElementAttachmentAssets.getParticleEffect(elementKey)) == null || particleKey.isEmpty() || (simple = ElementAuraRenderer.resolveSimpleParticle(particleKey)) == null) continue;
            float baseChance = 0.15f;
            float bonus = Math.max(0.0f, Math.min(0.15f, (float)(50 - remain) / 50.0f * 0.15f));
            float chance = baseChance + bonus;
            if (RNG.nextFloat() > chance) continue;
            double radius = 0.6;
            double angle = RNG.nextDouble() * Math.PI * 2.0;
            double yOff = 0.2 + RNG.nextDouble() * ((double)entity.getBbHeight() * 0.8);
            double px = entity.getX() + Math.cos(angle) * radius;
            double py = entity.getY() + yOff;
            double pz = entity.getZ() + Math.sin(angle) * radius;
            double vx = (RNG.nextDouble() - 0.5) * 0.02;
            double vy = 0.02 + RNG.nextDouble() * 0.02;
            double vz = (RNG.nextDouble() - 0.5) * 0.02;
            level.addParticle((ParticleOptions)simple, px, py, pz, vx, vy, vz);
        }
    }

    private static SimpleParticleType resolveSimpleParticle(String key) {
        try {
            ResourceLocation rl = ResourceLocation.parse((String)key);
            ParticleType type = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(rl);
            if (type instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)type;
                return simple;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static final class ClientAuraConfig {
        static final double RADIUS = 0.6;
        static final int FLASH_THRESHOLD = 50;

        private ClientAuraConfig() {
        }
    }
}

