/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.client.render;

import com.chadate.spellelemental.client.network.custom.ClientPayloadHandler;
import com.chadate.spellelemental.client.render.ElementIconRenderConfig;
import com.chadate.spellelemental.data.ElementContainerAttachment;
import com.chadate.spellelemental.data.SpellAttachments;
import com.chadate.spellelemental.element.attachment.data.UnifiedElementAttachmentAssets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="spellelemental", value={Dist.CLIENT})
public class ElementIconRenderer {
    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        Map<String, Integer> snapshot = container.snapshot();
        if (snapshot.isEmpty()) {
            return;
        }
        ElementIconRenderConfig cfg = ElementIconRenderConfig.get();
        ArrayList<String> elementKeys = new ArrayList<String>(snapshot.keySet());
        int count = elementKeys.size();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        poseStack.pushPose();
        poseStack.translate(0.0, (double)entity.getBbHeight() + cfg.getVerticalOffset(), 0.0);
        if (cfg.isFaceCamera()) {
            poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            if (cfg.isFlipBillboard()) {
                poseStack.scale(-1.0f, -1.0f, 1.0f);
            }
        }
        double totalWidth = (double)(count - 1) * cfg.getHorizontalSpacing();
        double startX = -totalWidth / 2.0;
        for (int i = 0; i < count; ++i) {
            String elementKey = (String)elementKeys.get(i);
            String iconPath = UnifiedElementAttachmentAssets.getIcon(elementKey);
            if (iconPath == null) continue;
            poseStack.pushPose();
            poseStack.translate(startX + (double)i * cfg.getHorizontalSpacing(), 0.0, 0.0);
            poseStack.scale(cfg.getQuadScale(), cfg.getQuadScale(), cfg.getQuadScale());
            ResourceLocation rl = ElementIconRenderer.resolveTexture(iconPath);
            if (rl != null) {
                float[][] vertices;
                Matrix4f matrix = poseStack.last().pose();
                VertexConsumer vc = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)rl));
                float z = cfg.getZDepth();
                int remain = ClientPayloadHandler.DisplayCache.predictRemaining(entity.getId(), elementKey);
                float a = ElementIconRenderer.computeAlpha(remain, cfg);
                if (a <= 0.0f) {
                    poseStack.popPose();
                    continue;
                }
                for (float[] v : vertices = new float[][]{{-1.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f, 0.0f}, {1.0f, -1.0f, 1.0f, 1.0f}, {-1.0f, -1.0f, 0.0f, 1.0f}}) {
                    vc.addVertex(matrix, v[0], v[1], z).setColor(1.0f, 1.0f, 1.0f, a).setUv(v[2], v[3]).setOverlay(OverlayTexture.NO_OVERLAY).setLight(event.getPackedLight()).setNormal(0.0f, 1.0f, 0.0f);
                }
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static float computeAlpha(int remain, ElementIconRenderConfig cfg) {
        if (remain < 0) {
            return cfg.getAlpha();
        }
        int th = cfg.getFlashingThreshold();
        if (remain > th) {
            return cfg.getAlpha();
        }
        float t = Math.max(0.0f, Math.min(1.0f, (float)remain / (float)th));
        float baseAlpha = cfg.getMinAlpha() + (cfg.getMaxAlpha() - cfg.getMinAlpha()) * t;
        float hz = cfg.getMinFlashHz() + (cfg.getMaxFlashHz() - cfg.getMinFlashHz()) * (1.0f - t);
        float timeSec = (float)(Minecraft.getInstance().level != null ? Minecraft.getInstance().level.getGameTime() : 0L) / 20.0f;
        float phase = (float)Math.sin(Math.PI * 2 * (double)hz * (double)timeSec);
        float flicker = 0.5f * (phase * 0.5f + 0.5f);
        return Math.max(0.0f, Math.min(1.0f, baseAlpha - flicker));
    }

    private static ResourceLocation resolveTexture(String iconPath) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (iconPath != null && !iconPath.isEmpty()) {
                ResourceLocation rl = ResourceLocation.parse((String)iconPath);
                Optional res = mc.getResourceManager().getResource(rl);
                if (res.isPresent()) {
                    return rl;
                }
                String candidate = rl.getPath();
                if (candidate.startsWith("textures/")) {
                    candidate = candidate.substring("textures/".length());
                }
                if (candidate.endsWith(".png")) {
                    candidate = candidate.substring(0, candidate.length() - 4);
                }
                ResourceLocation rl2 = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("textures/" + candidate + ".png"));
                if (mc.getResourceManager().getResource(rl2).isPresent()) {
                    return rl2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

