/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.command;

import com.chadate.spellelemental.util.AttributeModifierUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public class AttributeTestCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"attribute_test").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"physical_resistance").then(Commands.literal((String)"apply").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"percentage", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(context -> {
            LivingEntity target = (LivingEntity)EntityArgument.getEntity((CommandContext)context, (String)"target");
            double percentage = DoubleArgumentType.getDouble((CommandContext)context, (String)"percentage");
            AttributeModifierUtil.applyTemporaryPhysicalResistanceDown(target, percentage);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("\u5df2\u4e3a %s \u5e94\u7528 %.1f%% \u7684\u7269\u7406\u6297\u6027\u4e0b\u964d\u6548\u679c", target.getName().getString(), percentage * 100.0)), true);
            return 1;
        }))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> {
            LivingEntity target = (LivingEntity)EntityArgument.getEntity((CommandContext)context, (String)"target");
            AttributeModifierUtil.removePhysicalResistanceDown(target);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("\u5df2\u79fb\u9664 %s \u7684\u7269\u7406\u6297\u6027\u4e0b\u964d\u6548\u679c", target.getName().getString())), true);
            return 1;
        })))).then(Commands.literal((String)"check").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> {
            LivingEntity target = (LivingEntity)EntityArgument.getEntity((CommandContext)context, (String)"target");
            boolean hasEffect = AttributeModifierUtil.hasPhysicalResistanceDown(target);
            double amount = AttributeModifierUtil.getPhysicalResistanceDownAmount(target);
            if (hasEffect) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("%s \u5f53\u524d\u6709\u7269\u7406\u6297\u6027\u4e0b\u964d\u6548\u679c\uff1a%.1f%%", target.getName().getString(), amount * 100.0)), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("%s \u5f53\u524d\u6ca1\u6709\u7269\u7406\u6297\u6027\u4e0b\u964d\u6548\u679c", target.getName().getString())), false);
            }
            return 1;
        })))));
    }
}

