/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.element.attachment.attack;

import com.chadate.spellelemental.config.ServerConfig;
import com.chadate.spellelemental.data.ElementContainerAttachment;
import com.chadate.spellelemental.data.SpellAttachments;
import com.chadate.spellelemental.element.attachment.attack.SpellIcdTracker;
import com.chadate.spellelemental.element.attachment.data.UnifiedElementAttachmentAssets;
import com.chadate.spellelemental.event.element.ElementDecaySystem;
import com.chadate.spellelemental.network.ElementData;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ElementEventHandler {
    public static void handleElementAttachment(SpellDamageEvent event) {
        Entity attacker;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity target = event.getEntity();
        String spellId = event.getSpellDamageSource().spell().getSpellId();
        String school = event.getSpellDamageSource().spell().getSchoolType().getId().toString();
        String elementId = null;
        ResourceLocation spellKey = ResourceLocation.tryParse((String)spellId);
        if (spellKey != null) {
            elementId = ServerConfig.getSpellElementOverride(spellKey);
        }
        if ((elementId == null || elementId.isBlank()) && ((elementId = UnifiedElementAttachmentAssets.getElementIdBySchool(school)) == null || elementId.isBlank())) {
            return;
        }
        int duration = (Integer)ServerConfig.ELEMENT_ATTACHMENT_DEFAULT.get();
        if (spellKey != null) {
            duration = ServerConfig.getSpellAttachmentAmount(spellKey);
        }
        int attackerId = (attacker = event.getSpellDamageSource().getEntity()) != null ? attacker.getId() : -1;
        int step = ServerConfig.getIcdHitStep();
        int timeTicks = ServerConfig.getIcdTimeTicks();
        long now = target.level().getGameTime();
        boolean allow = SpellIcdTracker.allowAndRecord(attacker, (Entity)target, spellKey, now, step, timeTicks);
        if (!allow) {
            return;
        }
        ElementEventHandler.applyAttachment(target, elementId.toLowerCase(), duration, attackerId);
    }

    private static void applyAttachment(LivingEntity entity, String elementKeyLower, int duration, int attackerId) {
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        container.setValue(elementKeyLower, duration);
        long gameTime = entity.level().getGameTime();
        container.markAppliedWithAttacker(elementKeyLower, gameTime, attackerId);
        ElementDecaySystem.track(entity);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.players()) {
                double distance = player.distanceTo((Entity)entity);
                if (!(distance <= 64.0)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ElementData(entity.getId(), elementKeyLower, duration), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Entity target = event.getTarget();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)target;
        ElementContainerAttachment container = (ElementContainerAttachment)living.getData(SpellAttachments.ELEMENTS_CONTAINER);
        Map<String, Integer> snap = container.snapshot();
        String[] keys = snap.keySet().toArray(new String[0]);
        int[] values = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = snap.get(keys[i]);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ElementData.ElementSnapshot(living.getId(), keys, values), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

