/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.element.reaction.data;

import com.chadate.spellelemental.SpellElemental;
import com.chadate.spellelemental.element.reaction.data.ElementReactionRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class ElementReactionDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();

    public ElementReactionDataLoader() {
        super(GSON, "element_reactions");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        ElementReactionRegistry.clear();
        int ok = 0;
        int err = 0;
        SpellElemental.LOGGER.info("\u5f00\u59cb\u52a0\u8f7d\u5143\u7d20\u53cd\u5e94 JSON\uff0c\u5171 {} \u9879", (Object)object.size());
        for (Map.Entry<ResourceLocation, JsonElement> e : object.entrySet()) {
            ResourceLocation id = e.getKey();
            try {
                boolean damageVictim;
                boolean damageAttacker;
                boolean damageVictim2;
                boolean consumeElements;
                String trigger;
                String reactionId;
                JsonObject root;
                block87: {
                    block88: {
                        root = e.getValue().getAsJsonObject();
                        reactionId = root.has("reaction_id") && root.get("reaction_id").isJsonPrimitive() ? root.get("reaction_id").getAsString() : null;
                        String triggerType = root.has("trigger_type") && root.get("trigger_type").isJsonPrimitive() ? root.get("trigger_type").getAsString() : null;
                        trigger = triggerType == null ? "damage" : triggerType.trim().toLowerCase();
                        consumeElements = true;
                        if (root.has("consume_elements") && root.get("consume_elements").isJsonPrimitive()) {
                            try {
                                consumeElements = root.get("consume_elements").getAsBoolean();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (reactionId == null || reactionId.isBlank()) {
                            SpellElemental.LOGGER.error("\u5143\u7d20\u53cd\u5e94\u914d\u7f6e\u7f3a\u5c11 reaction_id: {}", (Object)id);
                            ++err;
                            continue;
                        }
                        if (!"tick".equals(trigger)) break block87;
                        if (root.has("ordered")) {
                            SpellElemental.LOGGER.error("[\u5143\u7d20\u53cd\u5e94: {}] tick \u7c7b\u578b\u4e0d\u652f\u6301\u65b9\u5411\u5316\u914d\u7f6e(ordered)", (Object)reactionId);
                            ++err;
                            continue;
                        }
                        if (!root.has("variants") || !root.get("variants").isJsonArray()) break block88;
                        JsonArray vars = root.getAsJsonArray("variants");
                        for (Object varEl : vars) {
                            if (!varEl.isJsonObject()) continue;
                            JsonObject var = varEl.getAsJsonObject();
                            HashMap<String, Integer> reqMap = new HashMap<String, Integer>();
                            if (var.has("requirements") && var.get("requirements").isJsonObject()) {
                                JsonObject req = var.getAsJsonObject("requirements");
                                for (Object en : req.entrySet()) {
                                    if (!((JsonElement)en.getValue()).isJsonPrimitive()) continue;
                                    reqMap.put((String)en.getKey(), Math.max(0, ((JsonElement)en.getValue()).getAsInt()));
                                }
                            }
                            HashMap<String, Integer> conMap = new HashMap<String, Integer>();
                            if (var.has("consume") && var.get("consume").isJsonObject()) {
                                Object en;
                                JsonObject con = var.getAsJsonObject("consume");
                                en = con.entrySet().iterator();
                                while (en.hasNext()) {
                                    Map.Entry en2 = (Map.Entry)en.next();
                                    if (!((JsonElement)en2.getValue()).isJsonPrimitive()) continue;
                                    conMap.put((String)en2.getKey(), Math.max(0, ((JsonElement)en2.getValue()).getAsInt()));
                                }
                            }
                            int interval = 1;
                            if (var.has("interval") && var.get("interval").isJsonPrimitive()) {
                                try {
                                    interval = Math.max(1, var.get("interval").getAsInt());
                                }
                                catch (Exception ignore) {
                                    interval = 1;
                                }
                            } else if (root.has("interval") && root.get("interval").isJsonPrimitive()) {
                                try {
                                    interval = Math.max(1, root.get("interval").getAsInt());
                                }
                                catch (Exception ignore) {
                                    interval = 1;
                                }
                            }
                            ArrayList<ElementReactionRegistry.ReactionEffect> tickEffects = new ArrayList<ElementReactionRegistry.ReactionEffect>();
                            if (var.has("effects")) {
                                if (var.get("effects").isJsonArray()) {
                                    effects = var.getAsJsonArray("effects");
                                    for (Object effEl : effects) {
                                        if (!effEl.isJsonObject()) continue;
                                        eff = effEl.getAsJsonObject();
                                        String string = type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                        if ("attachment".equalsIgnoreCase(type) || "consume".equalsIgnoreCase(type)) {
                                            String elemId;
                                            String string2 = eff.has("element") && eff.get("element").isJsonPrimitive() ? eff.get("element").getAsString() : (elemId = eff.has("element_id") && eff.get("element_id").isJsonPrimitive() ? eff.get("element_id").getAsString() : null);
                                            int amount = eff.has("amount") && eff.get("amount").isJsonPrimitive() ? eff.get("amount").getAsInt() : (eff.has("value") && eff.get("value").isJsonPrimitive() ? eff.get("value").getAsInt() : 0);
                                            float chance = eff.has("chance") && eff.get("chance").isJsonPrimitive() ? eff.get("chance").getAsFloat() : 1.0f;
                                            int duration = eff.has("duration") && eff.get("duration").isJsonPrimitive() ? eff.get("duration").getAsInt() : 0;
                                            tickEffects.add(new ElementReactionRegistry.ReactionEffect(type, elemId, amount, chance, duration));
                                            continue;
                                        }
                                        float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                        String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                        float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                        String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                        damageAttacker = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                        damageVictim2 = eff.has("damage_victim") && eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                        tickEffects.add(radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker || damageVictim2 ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker, damageVictim2) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                                    }
                                } else if (var.get("effects").isJsonObject()) {
                                    grouped = var.getAsJsonObject("effects");
                                    if (grouped.has("damage") && grouped.get("damage").isJsonArray()) {
                                        effects = grouped.getAsJsonArray("damage");
                                        effEl = effects.iterator();
                                        while (effEl.hasNext()) {
                                            effEl = (JsonElement)effEl.next();
                                            if (!effEl.isJsonObject()) continue;
                                            eff = effEl.getAsJsonObject();
                                            String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                            float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                            String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                            float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                            String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                            damageAttacker = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                            damageVictim = eff.has("damage_victim") && eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                            tickEffects.add(radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker || damageVictim ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker, damageVictim) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                                        }
                                    }
                                    if (grouped.has("attachment") && grouped.get("attachment").isJsonArray()) {
                                        attArr = grouped.getAsJsonArray("attachment");
                                        effEl = attArr.iterator();
                                        while (effEl.hasNext()) {
                                            String elemId;
                                            attEl = (JsonElement)effEl.next();
                                            if (!attEl.isJsonObject()) continue;
                                            att = attEl.getAsJsonObject();
                                            String string = att.has("element") && att.get("element").isJsonPrimitive() ? att.get("element").getAsString() : (elemId = att.has("element_id") && att.get("element_id").isJsonPrimitive() ? att.get("element_id").getAsString() : null);
                                            int amount = att.has("amount") && att.get("amount").isJsonPrimitive() ? att.get("amount").getAsInt() : (att.has("value") && att.get("value").isJsonPrimitive() ? att.get("value").getAsInt() : 0);
                                            float chance = att.has("chance") && att.get("chance").isJsonPrimitive() ? att.get("chance").getAsFloat() : 1.0f;
                                            int duration = att.has("duration") && att.get("duration").isJsonPrimitive() ? att.get("duration").getAsInt() : 0;
                                            tickEffects.add(new ElementReactionRegistry.ReactionEffect("attachment", elemId, amount, chance, duration));
                                        }
                                    }
                                    if (grouped.has("potion") && grouped.get("potion").isJsonArray()) {
                                        Iterator potionArr = grouped.getAsJsonArray("potion");
                                        effEl = potionArr.iterator();
                                        while (effEl.hasNext()) {
                                            float potionChance;
                                            JsonElement potionEl = (JsonElement)effEl.next();
                                            if (!potionEl.isJsonObject()) continue;
                                            JsonObject potion = potionEl.getAsJsonObject();
                                            String potionId = potion.has("potion_id") && potion.get("potion_id").isJsonPrimitive() ? potion.get("potion_id").getAsString() : null;
                                            int potionDuration = potion.has("duration") && potion.get("duration").isJsonPrimitive() ? potion.get("duration").getAsInt() : 200;
                                            int potionLevel = potion.has("level") && potion.get("level").isJsonPrimitive() ? potion.get("level").getAsInt() - 1 : 0;
                                            float f = potionChance = potion.has("chance") && potion.get("chance").isJsonPrimitive() ? potion.get("chance").getAsFloat() : 1.0f;
                                            if (potionId == null) continue;
                                            tickEffects.add(new ElementReactionRegistry.ReactionEffect("potion", potionId, potionDuration, potionLevel, potionChance));
                                        }
                                    }
                                }
                            } else if (root.has("effects")) {
                                if (root.get("effects").isJsonArray()) {
                                    effects = root.getAsJsonArray("effects");
                                    for (Object effEl : effects) {
                                        if (!effEl.isJsonObject()) continue;
                                        eff = effEl.getAsJsonObject();
                                        String string = type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                        if ("attachment".equalsIgnoreCase(type) || "consume".equalsIgnoreCase(type)) {
                                            String elemId;
                                            String string3 = eff.has("element") && eff.get("element").isJsonPrimitive() ? eff.get("element").getAsString() : (elemId = eff.has("element_id") && eff.get("element_id").isJsonPrimitive() ? eff.get("element_id").getAsString() : null);
                                            int amount = eff.has("amount") && eff.get("amount").isJsonPrimitive() ? eff.get("amount").getAsInt() : (eff.has("value") && eff.get("value").isJsonPrimitive() ? eff.get("value").getAsInt() : 0);
                                            float chance = eff.has("chance") && eff.get("chance").isJsonPrimitive() ? eff.get("chance").getAsFloat() : 1.0f;
                                            int duration = eff.has("duration") && eff.get("duration").isJsonPrimitive() ? eff.get("duration").getAsInt() : 0;
                                            tickEffects.add(new ElementReactionRegistry.ReactionEffect(type, elemId, amount, chance, duration));
                                            continue;
                                        }
                                        if ("potion".equalsIgnoreCase(type)) {
                                            float potionChance;
                                            String potionId = eff.has("potion_id") && eff.get("potion_id").isJsonPrimitive() ? eff.get("potion_id").getAsString() : null;
                                            int potionDuration = eff.has("duration") && eff.get("duration").isJsonPrimitive() ? eff.get("duration").getAsInt() : 200;
                                            int potionLevel = eff.has("level") && eff.get("level").isJsonPrimitive() ? eff.get("level").getAsInt() - 1 : 0;
                                            float f = potionChance = eff.has("chance") && eff.get("chance").isJsonPrimitive() ? eff.get("chance").getAsFloat() : 1.0f;
                                            if (potionId == null) continue;
                                            tickEffects.add(new ElementReactionRegistry.ReactionEffect("potion", potionId, potionDuration, potionLevel, potionChance));
                                            continue;
                                        }
                                        float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                        String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                        float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                        String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                        damageAttacker = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                        damageVictim2 = eff.has("damage_victim") && eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                        tickEffects.add(radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker || damageVictim2 ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker, damageVictim2) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                                    }
                                } else if (root.get("effects").isJsonObject()) {
                                    grouped = root.getAsJsonObject("effects");
                                    if (grouped.has("damage") && grouped.get("damage").isJsonArray()) {
                                        effects = grouped.getAsJsonArray("damage");
                                        effEl = effects.iterator();
                                        while (effEl.hasNext()) {
                                            effEl = (JsonElement)effEl.next();
                                            if (!effEl.isJsonObject()) continue;
                                            eff = effEl.getAsJsonObject();
                                            String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                            float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                            String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                            float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                            String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                            damageAttacker = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                            damageVictim = eff.has("damage_victim") && eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                            tickEffects.add(radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker || damageVictim ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker, damageVictim) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                                        }
                                    }
                                    if (grouped.has("attachment") && grouped.get("attachment").isJsonArray()) {
                                        attArr = grouped.getAsJsonArray("attachment");
                                        effEl = attArr.iterator();
                                        while (effEl.hasNext()) {
                                            String elemId;
                                            attEl = (JsonElement)effEl.next();
                                            if (!attEl.isJsonObject()) continue;
                                            att = attEl.getAsJsonObject();
                                            String string = att.has("element") && att.get("element").isJsonPrimitive() ? att.get("element").getAsString() : (elemId = att.has("element_id") && att.get("element_id").isJsonPrimitive() ? att.get("element_id").getAsString() : null);
                                            int amount = att.has("amount") && att.get("amount").isJsonPrimitive() ? att.get("amount").getAsInt() : (att.has("value") && att.get("value").isJsonPrimitive() ? att.get("value").getAsInt() : 0);
                                            float chance = att.has("chance") && att.get("chance").isJsonPrimitive() ? att.get("chance").getAsFloat() : 1.0f;
                                            int duration = att.has("duration") && att.get("duration").isJsonPrimitive() ? att.get("duration").getAsInt() : 0;
                                            tickEffects.add(new ElementReactionRegistry.ReactionEffect("attachment", elemId, amount, chance, duration));
                                        }
                                    }
                                }
                            }
                            ElementReactionRegistry.setTickRule(reactionId.trim(), reqMap, conMap, tickEffects, interval);
                        }
                        ElementReactionRegistry.add(reactionId.trim(), "tick");
                        ++ok;
                        continue;
                    }
                    HashMap<String, Integer> reqMap = new HashMap<String, Integer>();
                    if (root.has("requirements") && root.get("requirements").isJsonObject()) {
                        Object varEl;
                        JsonObject req = root.getAsJsonObject("requirements");
                        varEl = req.entrySet().iterator();
                        while (varEl.hasNext()) {
                            Map.Entry en = (Map.Entry)varEl.next();
                            if (!((JsonElement)en.getValue()).isJsonPrimitive()) continue;
                            reqMap.put((String)en.getKey(), Math.max(0, ((JsonElement)en.getValue()).getAsInt()));
                        }
                    }
                    HashMap conMap = new HashMap();
                    if (root.has("consume") && root.get("consume").isJsonObject()) {
                        JsonObject con = root.getAsJsonObject("consume");
                        for (Map.Entry en : con.entrySet()) {
                            if (!((JsonElement)en.getValue()).isJsonPrimitive()) continue;
                            conMap.put((String)en.getKey(), Math.max(0, ((JsonElement)en.getValue()).getAsInt()));
                        }
                    }
                    ArrayList<ElementReactionRegistry.ReactionEffect> tickEffects = new ArrayList<ElementReactionRegistry.ReactionEffect>();
                    int interval = 1;
                    if (root.has("interval") && root.get("interval").isJsonPrimitive()) {
                        try {
                            interval = Math.max(1, root.get("interval").getAsInt());
                        }
                        catch (Exception ignore) {
                            interval = 1;
                        }
                    }
                    if (root.has("effects")) {
                        JsonObject grouped;
                        if (root.get("effects").isJsonArray()) {
                            JsonArray effects = root.getAsJsonArray("effects");
                            for (JsonElement effEl : effects) {
                                if (!effEl.isJsonObject()) continue;
                                JsonObject eff = effEl.getAsJsonObject();
                                String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                boolean damageAttacker2 = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                boolean damageVictim3 = eff.has("damage_victim") && eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                tickEffects.add(radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker2 || damageVictim3 ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker2, damageVictim3) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                            }
                        } else if (root.get("effects").isJsonObject() && (grouped = root.getAsJsonObject("effects")).has("damage") && grouped.get("damage").isJsonArray()) {
                            JsonArray effects = grouped.getAsJsonArray("damage");
                            for (JsonElement effEl : effects) {
                                if (!effEl.isJsonObject()) continue;
                                JsonObject eff = effEl.getAsJsonObject();
                                String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                boolean damageAttacker3 = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                boolean damageVictim4 = eff.has("damage_victim") && eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                tickEffects.add(radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker3 || damageVictim4 ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker3, damageVictim4) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                            }
                        }
                    }
                    ElementReactionRegistry.setTickRule(reactionId.trim(), reqMap, conMap, tickEffects, interval);
                    ElementReactionRegistry.add(reactionId.trim(), "tick");
                    ++ok;
                    continue;
                }
                ElementReactionRegistry.add(reactionId.trim(), trigger);
                if ("damage".equals(trigger)) {
                    ElementReactionRegistry.setConsumeFlag(reactionId.trim(), consumeElements);
                    if (root.has("ordered") && root.get("ordered").isJsonArray()) {
                        JsonArray arr = root.getAsJsonArray("ordered");
                        for (JsonElement el : arr) {
                            JsonObject aobj;
                            if (el.isJsonArray()) {
                                JsonArray pair = el.getAsJsonArray();
                                if (pair.size() < 2 || !pair.get(0).isJsonPrimitive() || !pair.get(1).isJsonPrimitive()) continue;
                                ElementReactionRegistry.indexDamageCombination(reactionId.trim(), List.of(pair.get(0).getAsString(), pair.get(1).getAsString()), false);
                                continue;
                            }
                            if (!el.isJsonObject()) continue;
                            JsonObject obj = el.getAsJsonObject();
                            String src = obj.has("source") ? obj.get("source").getAsString() : null;
                            String tgt = obj.has("target") ? obj.get("target").getAsString() : null;
                            double ratio = 1.0;
                            if (obj.has("ratio") && obj.get("ratio").isJsonPrimitive()) {
                                try {
                                    ratio = Math.max(0.0, obj.get("ratio").getAsDouble());
                                }
                                catch (Exception ex) {
                                    ratio = 1.0;
                                }
                            }
                            if (src == null || tgt == null) continue;
                            ElementReactionRegistry.indexDamageOrdered(reactionId.trim(), src, tgt);
                            if (ratio != 1.0) {
                                ElementReactionRegistry.setConsumeRatio(src, tgt, ratio);
                            }
                            if (!obj.has("effects")) continue;
                            if (obj.get("effects").isJsonArray()) {
                                JsonArray dirEffs = obj.getAsJsonArray("effects");
                                for (JsonElement de : dirEffs) {
                                    if (!de.isJsonObject()) continue;
                                    JsonObject eff = de.getAsJsonObject();
                                    String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                    float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                    String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                    float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                    String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                    boolean damageAttacker4 = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                    damageVictim2 = !eff.has("damage_victim") || eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                    ElementReactionRegistry.addDirectionalEffect(src, tgt, radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker4 || !damageVictim2 ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker4, damageVictim2) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                                }
                                continue;
                            }
                            if (!obj.get("effects").isJsonObject()) continue;
                            JsonObject grouped = obj.getAsJsonObject("effects");
                            if (grouped.has("damage") && grouped.get("damage").isJsonArray()) {
                                JsonArray dirEffs = grouped.getAsJsonArray("damage");
                                for (JsonElement de : dirEffs) {
                                    if (!de.isJsonObject()) continue;
                                    JsonObject eff = de.getAsJsonObject();
                                    String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                    float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                    String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                    float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                    String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                    damageAttacker = eff.has("damage_attacker") && eff.get("damage_attacker").isJsonPrimitive() && eff.get("damage_attacker").getAsBoolean();
                                    damageVictim = !eff.has("damage_victim") || eff.get("damage_victim").isJsonPrimitive() && eff.get("damage_victim").getAsBoolean();
                                    ElementReactionRegistry.addDirectionalEffect(src, tgt, radius > 0.0f || !damageTypeStr.isEmpty() || !damageAttacker || !damageVictim ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr, damageAttacker, damageVictim) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                                }
                            }
                            if (grouped.has("attribute") && grouped.get("attribute").isJsonArray()) {
                                JsonArray attrEffs = grouped.getAsJsonArray("attribute");
                                for (JsonElement ae : attrEffs) {
                                    if (!ae.isJsonObject()) continue;
                                    aobj = ae.getAsJsonObject();
                                    String attrId = aobj.has("attribute_id") && aobj.get("attribute_id").isJsonPrimitive() ? aobj.get("attribute_id").getAsString() : "";
                                    String op = aobj.has("type") && aobj.get("type").isJsonPrimitive() ? aobj.get("type").getAsString() : "add";
                                    double val = aobj.has("value") && aobj.get("value").isJsonPrimitive() ? aobj.get("value").getAsDouble() : 0.0;
                                    int dur = aobj.has("duration") && aobj.get("duration").isJsonPrimitive() ? Math.max(0, aobj.get("duration").getAsInt()) : 0;
                                    ElementReactionRegistry.addDirectionalAttributeEffect(src, tgt, new ElementReactionRegistry.AttributeEffect(attrId, op, val, dur));
                                }
                            }
                            if (!grouped.has("attachment") || !grouped.get("attachment").isJsonArray()) continue;
                            JsonArray attEffs = grouped.getAsJsonArray("attachment");
                            for (JsonElement ae : attEffs) {
                                int duration;
                                if (!ae.isJsonObject()) continue;
                                aobj = ae.getAsJsonObject();
                                String elementId = aobj.has("element_id") && aobj.get("element_id").isJsonPrimitive() ? aobj.get("element_id").getAsString() : null;
                                int amount = aobj.has("amount") && aobj.get("amount").isJsonPrimitive() ? Math.max(0, aobj.get("amount").getAsInt()) : 0;
                                float chance = aobj.has("chance") && aobj.get("chance").isJsonPrimitive() ? aobj.get("chance").getAsFloat() : 1.0f;
                                int n = duration = aobj.has("duration") && aobj.get("duration").isJsonPrimitive() ? Math.max(0, aobj.get("duration").getAsInt()) : 0;
                                if (elementId == null || elementId.isBlank() || amount <= 0) continue;
                                ElementReactionRegistry.addDirectionalEffect(src, tgt, new ElementReactionRegistry.ReactionEffect("attachment", elementId, amount, chance, duration));
                            }
                        }
                    } else if (root.has("elements") && root.get("elements").isJsonArray()) {
                        JsonArray el = root.getAsJsonArray("elements");
                        if (el.size() >= 2 && el.get(0).isJsonPrimitive() && el.get(1).isJsonPrimitive()) {
                            ElementReactionRegistry.indexDamageCombination(reactionId.trim(), List.of(el.get(0).getAsString(), el.get(1).getAsString()), true);
                        } else {
                            SpellElemental.LOGGER.warn("\u5143\u7d20\u53cd\u5e94\u7f3a\u5c11\u6709\u6548\u7684 elements \u5b57\u6bb5: {}", (Object)id);
                        }
                    } else {
                        SpellElemental.LOGGER.warn("\u5143\u7d20\u53cd\u5e94\u7f3a\u5c11\u6709\u6548\u7684 ordered/elements \u7ec4\u5408\u5b57\u6bb5: {}", (Object)id);
                    }
                }
                if (!"tick".equals(trigger) && root.has("effects")) {
                    if (root.get("effects").isJsonArray()) {
                        JsonArray effects = root.getAsJsonArray("effects");
                        for (JsonElement effEl : effects) {
                            if (!effEl.isJsonObject()) continue;
                            JsonObject eff = effEl.getAsJsonObject();
                            String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                            float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                            String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                            float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                            String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                            ElementReactionRegistry.addEffect(reactionId.trim(), radius > 0.0f || !damageTypeStr.isEmpty() ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                        }
                    } else if (root.get("effects").isJsonObject()) {
                        JsonObject grouped = root.getAsJsonObject("effects");
                        if (grouped.has("damage") && grouped.get("damage").isJsonArray()) {
                            JsonArray effects = grouped.getAsJsonArray("damage");
                            for (JsonElement effEl : effects) {
                                if (!effEl.isJsonObject()) continue;
                                JsonObject eff = effEl.getAsJsonObject();
                                String type = eff.has("type") && eff.get("type").isJsonPrimitive() ? eff.get("type").getAsString() : "";
                                float multiplier = eff.has("multiplier") && eff.get("multiplier").isJsonPrimitive() ? eff.get("multiplier").getAsFloat() : 1.0f;
                                String formula = eff.has("formula") && eff.get("formula").isJsonPrimitive() ? eff.get("formula").getAsString() : "";
                                float radius = eff.has("radius") && eff.get("radius").isJsonPrimitive() ? eff.get("radius").getAsFloat() : 0.0f;
                                String damageTypeStr = eff.has("damage_type") && eff.get("damage_type").isJsonPrimitive() ? eff.get("damage_type").getAsString() : "";
                                ElementReactionRegistry.addEffect(reactionId.trim(), radius > 0.0f || !damageTypeStr.isEmpty() ? new ElementReactionRegistry.ReactionEffect(type, multiplier, formula, radius, damageTypeStr) : new ElementReactionRegistry.ReactionEffect(type, multiplier, formula));
                            }
                        }
                        if (grouped.has("attribute") && grouped.get("attribute").isJsonArray()) {
                            JsonArray attrEffs = grouped.getAsJsonArray("attribute");
                            for (JsonElement ae : attrEffs) {
                                if (!ae.isJsonObject()) continue;
                                JsonObject aobj = ae.getAsJsonObject();
                                String attrId = aobj.has("attribute_id") && aobj.get("attribute_id").isJsonPrimitive() ? aobj.get("attribute_id").getAsString() : "";
                                String op = aobj.has("type") && aobj.get("type").isJsonPrimitive() ? aobj.get("type").getAsString() : "add";
                                double val = aobj.has("value") && aobj.get("value").isJsonPrimitive() ? aobj.get("value").getAsDouble() : 0.0;
                                int dur = aobj.has("duration") && aobj.get("duration").isJsonPrimitive() ? Math.max(0, aobj.get("duration").getAsInt()) : 0;
                                ElementReactionRegistry.addAttributeEffect(reactionId.trim(), new ElementReactionRegistry.AttributeEffect(attrId, op, val, dur));
                            }
                        }
                    }
                }
                ++ok;
            }
            catch (JsonParseException ex) {
                SpellElemental.LOGGER.error("\u89e3\u6790\u5143\u7d20\u53cd\u5e94\u5931\u8d25 {}: {}", (Object)id, (Object)ex.getMessage());
                ++err;
            }
            catch (Exception ex) {
                SpellElemental.LOGGER.error("\u52a0\u8f7d\u5143\u7d20\u53cd\u5e94\u51fa\u9519 {}: {}", new Object[]{id, ex.getMessage(), ex});
                ++err;
            }
        }
        SpellElemental.LOGGER.info("\u5143\u7d20\u53cd\u5e94\u52a0\u8f7d\u5b8c\u6210: {} \u4e2a\u6210\u529f, {} \u4e2a\u9519\u8bef", (Object)ok, (Object)err);
    }
}

