/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.element.reaction.runtime;

import com.chadate.spellelemental.SpellElemental;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class AttributeEffectManager {
    private static final Map<Integer, List<ActiveAttributeEffect>> ACTIVE_EFFECTS = new ConcurrentHashMap<Integer, List<ActiveAttributeEffect>>();

    public static void registerTimedEffect(LivingEntity entity, Holder<Attribute> attributeHolder, ResourceLocation modifierId, int durationTicks) {
        if (entity == null || entity.level().isClientSide() || durationTicks <= 0) {
            SpellElemental.LOGGER.warn("\u8df3\u8fc7\u5b9a\u65f6\u6548\u679c\u6ce8\u518c\uff1aentity={}, isClientSide={}, duration={}", new Object[]{entity != null ? entity.getName().getString() : "null", entity != null ? Boolean.valueOf(entity.level().isClientSide()) : "unknown", durationTicks});
            return;
        }
        long currentTime = entity.level().getGameTime();
        long expireTime = currentTime + (long)durationTicks;
        int entityId = entity.getId();
        List effects = ACTIVE_EFFECTS.computeIfAbsent(entityId, k -> new ArrayList());
        boolean found = false;
        for (int i = 0; i < effects.size(); ++i) {
            ActiveAttributeEffect existing = (ActiveAttributeEffect)effects.get(i);
            if (!existing.modifierId.equals((Object)modifierId) || !existing.attributeHolder.equals(attributeHolder)) continue;
            effects.set(i, new ActiveAttributeEffect(entityId, attributeHolder, modifierId, expireTime));
            found = true;
            break;
        }
        if (!found) {
            ActiveAttributeEffect effect = new ActiveAttributeEffect(entityId, attributeHolder, modifierId, expireTime);
            effects.add(effect);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (ACTIVE_EFFECTS.isEmpty()) {
            return;
        }
        ServerLevel level = event.getServer().overworld();
        long currentTime = level.getGameTime();
        Iterator<Map.Entry<Integer, List<ActiveAttributeEffect>>> entityIterator = ACTIVE_EFFECTS.entrySet().iterator();
        while (entityIterator.hasNext()) {
            Map.Entry<Integer, List<ActiveAttributeEffect>> entry = entityIterator.next();
            int entityId = entry.getKey();
            List<ActiveAttributeEffect> effects = entry.getValue();
            LivingEntity livingEntity = AttributeEffectManager.findLivingEntityById(event.getServer(), entityId);
            if (livingEntity == null) continue;
            Iterator<ActiveAttributeEffect> effectIterator = effects.iterator();
            while (effectIterator.hasNext()) {
                ActiveAttributeEffect effect = effectIterator.next();
                if (currentTime < effect.expireTime) continue;
                AttributeEffectManager.removeAttributeModifier(livingEntity, effect.attributeHolder, effect.modifierId);
                effectIterator.remove();
            }
            if (!effects.isEmpty()) continue;
            entityIterator.remove();
        }
    }

    private static LivingEntity findLivingEntityById(MinecraftServer server, int entityId) {
        for (ServerLevel level : server.getAllLevels()) {
            Entity entity = level.getEntity(entityId);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    private static void removeAttributeModifier(LivingEntity entity, Holder<Attribute> attributeHolder, ResourceLocation modifierId) {
        try {
            AttributeInstance instance = entity.getAttribute(attributeHolder);
            if (instance != null) {
                instance.removeModifier(modifierId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public record ActiveAttributeEffect(int entityId, Holder<Attribute> attributeHolder, ResourceLocation modifierId, long expireTime) {
    }
}

