/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.event;

import com.chadate.spellelemental.integration.jei.data.SwordOilConfigLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class SwordOilTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        SwordOilConfigLoader.SwordOilConfig config = SwordOilConfigLoader.getSwordOilConfig(stack.getItem());
        if (config != null) {
            event.getToolTip().add(Component.empty());
            event.getToolTip().add(Component.literal((String)"\u25c6 ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"tooltip.spellelemental.sword_oil.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
            MutableComponent elementIcon = Component.literal((String)(SwordOilTooltipHandler.getElementIcon(config.getElement()) + " ")).withStyle(ChatFormatting.WHITE);
            MutableComponent elementName = Component.translatable((String)("element.spellelemental." + config.getElement())).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
            event.getToolTip().add(Component.literal((String)"  ").append((Component)elementIcon).append((Component)Component.translatable((String)"tooltip.spellelemental.sword_oil.element", (Object[])new Object[]{elementName}).withStyle(ChatFormatting.GRAY)));
            MutableComponent amountIcon = Component.literal((String)"\u25c6 ").withStyle(ChatFormatting.WHITE);
            MutableComponent amountValue = Component.literal((String)String.valueOf(config.getAmount())).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
            event.getToolTip().add(Component.literal((String)"  ").append((Component)amountIcon).append((Component)Component.translatable((String)"tooltip.spellelemental.sword_oil.amount", (Object[])new Object[]{amountValue}).withStyle(ChatFormatting.GRAY)));
        }
    }

    private static String getElementIcon(String element) {
        switch (element) {
            default: 
        }
        return "\u25c6";
    }
}

