/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.event.element;

import com.chadate.spellelemental.data.ElementContainerAttachment;
import com.chadate.spellelemental.data.SpellAttachments;
import com.chadate.spellelemental.network.ElementData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class ElementDecaySystem {
    private static final Set<LivingEntity> TRACKED = Collections.newSetFromMap(new WeakHashMap());

    private ElementDecaySystem() {
    }

    public static void track(LivingEntity entity) {
        if (entity != null && !entity.level().isClientSide()) {
            TRACKED.add(entity);
        }
    }

    public static void elementDecay(ServerTickEvent.Post event) {
        event.getServer().overworld();
        if (TRACKED.isEmpty()) {
            return;
        }
        TRACKED.removeIf(entity -> entity == null || !entity.isAlive() || entity.level().isClientSide());
        for (LivingEntity entity2 : TRACKED) {
            ElementContainerAttachment container = (ElementContainerAttachment)entity2.getData(SpellAttachments.ELEMENTS_CONTAINER);
            Map<String, Integer> snap = container.snapshot();
            if (snap.isEmpty()) continue;
            for (Map.Entry<String, Integer> e : snap.entrySet()) {
                String key = e.getKey();
                int value = e.getValue();
                if (value <= 0) continue;
                container.setValue(key, --value);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ElementData(entity2.getId(), key, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

