/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.integration.jei.data;

import com.chadate.spellelemental.SpellElemental;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SwordOilConfigLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    private static final List<SwordOilConfig> SWORD_OIL_CONFIGS = new ArrayList<SwordOilConfig>();
    private static boolean initialized = false;

    public SwordOilConfigLoader() {
        super(GSON, "sword_oils");
    }

    public static void preInitialize() {
        if (initialized) {
            return;
        }
        SWORD_OIL_CONFIGS.clear();
        initialized = true;
        SpellElemental.LOGGER.info("\u5251\u6cb9\u914d\u7f6e\u52a0\u8f7d\u5668\u5df2\u9884\u521d\u59cb\u5316\uff0c\u7b49\u5f85\u6570\u636e\u5305\u52a0\u8f7d");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        SWORD_OIL_CONFIGS.clear();
        initialized = false;
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                JsonObject jsonObject;
                if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has("sword_oils")) continue;
                JsonArray swordOilsArray = jsonObject.getAsJsonArray("sword_oils");
                for (JsonElement oilElement : swordOilsArray) {
                    JsonObject oilObject;
                    SwordOilConfig config;
                    if (!oilElement.isJsonObject() || (config = this.parseSwordOilConfig(oilObject = oilElement.getAsJsonObject())) == null) continue;
                    SWORD_OIL_CONFIGS.add(config);
                }
            }
            catch (Exception exception) {
            }
        }
        SpellElemental.LOGGER.info("\u7cbe\u6cb9\u914d\u7f6e\u6570\u636e\u5305\u52a0\u8f7d\u5b8c\u6210\uff0c\u5171\u52a0\u8f7d {} \u4e2a\u914d\u7f6e", (Object)SWORD_OIL_CONFIGS.size());
    }

    private SwordOilConfig parseSwordOilConfig(JsonObject jsonObject) {
        try {
            String itemId = jsonObject.get("item").getAsString();
            String element = jsonObject.get("element").getAsString();
            int amount = jsonObject.get("amount").getAsInt();
            String displayName = jsonObject.has("display_name") ? jsonObject.get("display_name").getAsString() : itemId;
            return new SwordOilConfig(itemId, element, amount, displayName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<SwordOilConfig> getSwordOilConfigs() {
        if (SWORD_OIL_CONFIGS.isEmpty() && !initialized) {
            SwordOilConfigLoader.preInitialize();
        }
        return new ArrayList<SwordOilConfig>(SWORD_OIL_CONFIGS);
    }

    public static SwordOilConfig getSwordOilConfig(Item item) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        return SWORD_OIL_CONFIGS.stream().filter(config -> config.getItemId().equals(itemId.toString())).findFirst().orElse(null);
    }

    public static boolean isSwordOil(Item item) {
        return SwordOilConfigLoader.getSwordOilConfig(item) != null;
    }

    public static void clearConfigs() {
        SWORD_OIL_CONFIGS.clear();
    }

    public static void addConfig(SwordOilConfig config) {
        SWORD_OIL_CONFIGS.add(config);
    }

    public static class SwordOilConfig {
        private final String itemId;
        private final String element;
        private final int amount;
        private final String displayName;

        public SwordOilConfig(String itemId, String element, int amount, String displayName) {
            this.itemId = itemId;
            this.element = element;
            this.amount = amount;
            this.displayName = displayName;
        }

        public String getItemId() {
            return this.itemId;
        }

        public String getElement() {
            return this.element;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ItemStack getItemStack() {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)this.itemId);
            Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
            return new ItemStack((ItemLike)item);
        }
    }
}

