/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.frankv.staaaaaaaaaaaack.config.StxckClientConfig;
import me.frankv.staaaaaaaaaaaack.config.StxckCommonConfig;
import me.frankv.staaaaaaaaaaaack.mixin.ItemEntityAccessor;
import me.frankv.staaaaaaaaaaaack.mixin.ItemStackAccessor;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Stxck {
    public static final String MODID = "staaaaaaaaaaaack";
    public static final TagKey<Item> BLACK_LIST_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"staaaaaaaaaaaack", (String)"blacklist"));
    public static final String EXTRA_ITEM_COUNT_TAG = "StxckExtraItemCount";
    private static Set<Item> itemList;
    private static Set<ResourceLocation> dimensionList;
    public static StxckCommonConfig commonConfig;
    public static StxckClientConfig clientConfig;
    private static EntityDataAccessor<Integer> DATA_EXTRA_ITEM_COUNT;

    private static Set<Item> getItemList() {
        if (itemList == null) {
            itemList = commonConfig.getItemList().stream().map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).collect(Collectors.toUnmodifiableSet());
        }
        return itemList;
    }

    private static Set<ResourceLocation> getDimensionList() {
        if (dimensionList == null) {
            dimensionList = commonConfig.getDimensionList().stream().map(ResourceLocation::parse).collect(Collectors.toUnmodifiableSet());
        }
        return dimensionList;
    }

    public static void setDataExtraItemCount(EntityDataAccessor<Integer> entityDataAccessor) {
        if (DATA_EXTRA_ITEM_COUNT != null) {
            return;
        }
        DATA_EXTRA_ITEM_COUNT = entityDataAccessor;
    }

    public static void refillItemStack(ItemEntity entity) {
        int extraItemCount = Stxck.getExtraItemCount(entity);
        if (extraItemCount <= 0) {
            return;
        }
        ItemStack stack = entity.getItem();
        Optional.ofNullable(((ItemStackAccessor)stack).accessItem()).map(Item::getDefaultMaxStackSize).ifPresent(maxSize -> {
            if (stack.getCount() == maxSize.intValue()) {
                return;
            }
            int x = maxSize - stack.getCount();
            int refillCount = Math.min(x, extraItemCount);
            stack.grow(refillCount);
            Stxck.setExtraItemCount(entity, extraItemCount - refillCount);
            entity.setItem(stack.copy());
        });
    }

    public static boolean areMergable(ItemEntity itemEntity, ItemEntity itemEntity1) {
        int maxExtraSize = commonConfig.getMaxSize();
        if (maxExtraSize - Stxck.getExtraItemCount(itemEntity) < Stxck.getTotalCount(itemEntity1) && maxExtraSize - Stxck.getExtraItemCount(itemEntity1) < Stxck.getTotalCount(itemEntity)) {
            return false;
        }
        ItemStack itemStack = itemEntity.getItem();
        ItemStack itemStack1 = itemEntity1.getItem();
        return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)itemStack1);
    }

    public static void grow(ItemEntity entity, int count) {
        Stxck.setExtraItemCount(entity, Stxck.getExtraItemCount(entity) + count);
        Stxck.refillItemStack(entity);
    }

    public static boolean isMergable(ItemEntity entity) {
        ItemEntityAccessor accessor = (ItemEntityAccessor)entity;
        int pickupDelay = accessor.getPickupDelay();
        int age = accessor.getAge();
        return entity.isAlive() && pickupDelay != Short.MAX_VALUE && age != Short.MIN_VALUE && age < 6000;
    }

    public static Optional<String> getOverlayText(ItemEntity entity) {
        boolean alwaysShowItemCount = clientConfig.isAlwaysShowItemCount();
        return switch (clientConfig.getOverlayDisplayMode()) {
            default -> throw new MatchException(null, null);
            case StxckClientConfig.OverlayDisplayMode.ITEM_COUNT -> Stxck.getTotalCountOverlayText(entity, alwaysShowItemCount);
            case StxckClientConfig.OverlayDisplayMode.STACK_COUNT -> {
                boolean show;
                int maxStackSize = entity.getItem().getMaxStackSize();
                int stackCount = (int)Math.ceil((double)Stxck.getTotalCount(entity) / (double)maxStackSize);
                boolean v1 = show = stackCount > 1 || alwaysShowItemCount;
                if (show) {
                    yield Optional.of(String.format("%dx", stackCount));
                }
                yield Optional.empty();
            }
        };
    }

    private static Optional<String> getTotalCountOverlayText(ItemEntity entity, boolean alwaysShowItemCount) {
        int total = Stxck.getTotalCount(entity);
        if (total >= 1000000000) {
            return Optional.of(String.format("%.3fB", Float.valueOf((float)total / 1.0E9f)));
        }
        if (total >= 1000000) {
            return Optional.of(String.format("%.2fM", Float.valueOf((float)total / 1000000.0f)));
        }
        if (total >= 10000) {
            return Optional.of(String.format("%.1fK", Float.valueOf((float)total / 1000.0f)));
        }
        if (alwaysShowItemCount || total > entity.getItem().getMaxStackSize()) {
            return Optional.of(String.valueOf(total));
        }
        return Optional.empty();
    }

    public static int getTotalCount(ItemEntity entity) {
        return entity.getItem().getCount() + Stxck.getExtraItemCount(entity);
    }

    public static int getExtraItemCount(ItemEntity entity) {
        return (Integer)entity.getEntityData().get(DATA_EXTRA_ITEM_COUNT);
    }

    public static void setExtraItemCount(ItemEntity entity, int count) {
        entity.getEntityData().set(DATA_EXTRA_ITEM_COUNT, (Object)count);
    }

    public static boolean tryRefillItemStackOnEntityRemove(Entity entity, Entity.RemovalReason reason) {
        if (!entity.getType().equals(EntityType.ITEM) || !reason.equals((Object)Entity.RemovalReason.DISCARDED)) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (Stxck.getExtraItemCount(itemEntity) <= 0) {
            return false;
        }
        ItemStack copied = itemEntity.getItem().copy();
        itemEntity.setItem(copied);
        copied.setCount(0);
        Stxck.refillItemStack(itemEntity);
        return true;
    }

    public static void tryToMerge(ItemEntity itemEntity, ItemEntity itemEntity1) {
        Stxck.tryToMerge(itemEntity, itemEntity1, false);
    }

    public static void tryToMerge(ItemEntity itemEntity, ItemEntity itemEntity1, boolean mergeToExisted) {
        if (Objects.equals(itemEntity.getOwner(), itemEntity1.getOwner()) && Stxck.areMergable(itemEntity, itemEntity1)) {
            if (mergeToExisted || Stxck.getTotalCount(itemEntity1) < Stxck.getTotalCount(itemEntity)) {
                Stxck.merge(itemEntity, itemEntity1);
            } else {
                Stxck.merge(itemEntity1, itemEntity);
            }
        }
    }

    public static void merge(ItemEntity consumer, ItemEntity supplier) {
        ItemEntityAccessor consumerAccessor = (ItemEntityAccessor)consumer;
        ItemEntityAccessor supplierAccessor = (ItemEntityAccessor)supplier;
        consumerAccessor.setPickupDelay(Math.max(consumerAccessor.getPickupDelay(), supplierAccessor.getPickupDelay()));
        consumerAccessor.setAge(Math.min(consumerAccessor.getAge(), supplierAccessor.getAge()));
        Stxck.grow(consumer, Stxck.getTotalCount(supplier));
        Stxck.setExtraItemCount(supplier, 0);
        supplier.setItem(ItemStack.EMPTY);
        supplier.discard();
    }

    public static boolean isBlackListItem(ItemEntity itemEntity) {
        ResourceLocation dim = itemEntity.level().dimension().location();
        if (Stxck.getDimensionList().contains(dim) ^ commonConfig.isDimensionListAsWhitelist()) {
            return true;
        }
        ItemStack itemStack = itemEntity.getItem();
        if (!commonConfig.isEnableForUnstackableItem() && itemStack.getMaxStackSize() == 1) {
            return true;
        }
        return itemStack.is(BLACK_LIST_TAG) || Stxck.getItemList().contains(itemStack.getItem()) ^ commonConfig.isItemListAsWhitelist();
    }
}

