/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack.config;

import java.util.ArrayList;
import java.util.List;
import me.frankv.staaaaaaaaaaaack.config.StxckCommonConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class StxckNeoForgeCommonConfig
implements StxckCommonConfig {
    private final ModConfigSpec.DoubleValue maxMergeDistanceHorizontal;
    private final ModConfigSpec.DoubleValue maxMergeDistanceVertical;
    private final ModConfigSpec.IntValue maxSize;
    private final ModConfigSpec.BooleanValue enableForUnstackableItem;
    private final ModConfigSpec.BooleanValue itemListAsWhitelist;
    private final ModConfigSpec.ConfigValue<List<? extends String>> itemList;
    private final ModConfigSpec.BooleanValue dimensionListAsWhitelist;
    private final ModConfigSpec.ConfigValue<List<? extends String>> dimensionList;

    public StxckNeoForgeCommonConfig(ModConfigSpec.Builder builder) {
        builder.push("Item merge settings");
        this.maxMergeDistanceHorizontal = builder.comment("The maximum horizontal block distance over which dropped items attempt to merge with each other.").comment("Default: 1.25, Minecraft default: 0.5").defineInRange("maxMergeDistanceHorizontal", 1.25, 0.5, 10.0);
        this.maxMergeDistanceVertical = builder.comment("The maximum vertical block distance over which dropped items attempt to merge with each other.").comment("Default: 0.0, Minecraft default: 0.0").defineInRange("maxMergeDistanceVertical", 0.0, 0.0, 10.0);
        this.maxSize = builder.comment("The maximum number of extra items that an item entity can hold.").comment(String.format("Default: %d", Integer.MAX_VALUE)).defineInRange("maxSize", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.enableForUnstackableItem = builder.comment("Enable for merging non-stackable item.").comment("Should be used with caution while playing with other mods.").comment("Default: false").define("enableForUnstackableItem", false);
        this.itemListAsWhitelist = builder.comment("Set this \"true\" to make `itemList` a whitelist, it's a blacklist when set to \"false\".").comment("Default: false").define("itemListAsWhitelist", false);
        this.itemList = builder.comment("The list of items that should or should not exceed their original max stack size.").comment("Or You can by using the item tag \"#staaaaaaaaaaaack:blacklist\" to blacklist the item.").comment("e.g., [\"minecraft:diamond_block\", \"minecraft:coal\"]").defineList("itemList", ArrayList::new, () -> "", o -> o instanceof String);
        this.dimensionListAsWhitelist = builder.comment("Set this \"true\" to make `dimensionList` a whitelist, it's a blacklist when set to \"false\".").comment("Default: false").define("dimensionListAsWhitelist", false);
        this.dimensionList = builder.comment("The list of dimension that should or should not make item exceed their original max stack size.").comment("e.g., [\"minecraft:overworld\", \"minecraft:the_nether\"]").defineList("dimensionList", ArrayList::new, () -> "", o -> o instanceof String);
        builder.pop();
    }

    @Override
    public double getMaxMergeDistanceHorizontal() {
        return (Double)this.maxMergeDistanceHorizontal.get();
    }

    @Override
    public double getMaxMergeDistanceVertical() {
        return (Double)this.maxMergeDistanceVertical.get();
    }

    @Override
    public int getMaxSize() {
        return (Integer)this.maxSize.get();
    }

    @Override
    public boolean isEnableForUnstackableItem() {
        return (Boolean)this.enableForUnstackableItem.get();
    }

    @Override
    public boolean isItemListAsWhitelist() {
        return (Boolean)this.itemListAsWhitelist.get();
    }

    @Override
    public List<? extends String> getItemList() {
        return (List)this.itemList.get();
    }

    @Override
    public boolean isDimensionListAsWhitelist() {
        return (Boolean)this.dimensionListAsWhitelist.get();
    }

    @Override
    public List<? extends String> getDimensionList() {
        return (List)this.dimensionList.get();
    }

    @Override
    public StxckCommonConfig.CleanDropsScheduler getCleanDropsScheduler() {
        return null;
    }

    @Override
    public int getCleanDropsIntervalSeconds() {
        return 0;
    }

    @Override
    public int getCleanDropsItemCountThreshold() {
        return 0;
    }

    @Override
    public boolean onlyCleanSingleItemType() {
        return false;
    }

    @Override
    public boolean isCleanDropsItemListAsWhitelist() {
        return false;
    }

    @Override
    public List<? extends String> getCleanDropsItemList() {
        return List.of();
    }

    @Override
    public boolean isCleanDropsDimensionListAsWhitelist() {
        return false;
    }

    @Override
    public List<? extends String> getCleanDropsDimensionList() {
        return List.of();
    }
}

