/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack.mixin;

import me.frankv.staaaaaaaaaaaack.Stxck;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    @Unique
    private static final EntityDataAccessor<Integer> STXCK_DATA_EXTRA_ITEM_COUNT = SynchedEntityData.defineId(ItemEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Unique
    private boolean discardedTick = false;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="RETURN")})
    private void constructorSetExtraCountInject(ItemEntity itemEntity, CallbackInfo ci) {
        Stxck.setExtraItemCount(this.stxck$getThis(), Stxck.getExtraItemCount(itemEntity));
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="RETURN")})
    private void constructorSetExtraCountInject(CallbackInfo ci) {
        Stxck.setExtraItemCount(this.stxck$getThis(), 0);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    private void defineSynchedDataForExtraItemCount(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(STXCK_DATA_EXTRA_ITEM_COUNT, (Object)0);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V", shift=At.Shift.AFTER)})
    private void tickInject(CallbackInfo ci) {
        this.discardedTick = false;
        Stxck.refillItemStack(this.stxck$getThis());
    }

    @Inject(method={"isMergable"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceIsMergable(CallbackInfoReturnable<Boolean> cir) {
        ItemEntity self = this.stxck$getThis();
        ItemStack itemStack = self.getItem();
        if (Stxck.isBlackListItem(self) || Stxck.getExtraItemCount(self) >= Stxck.commonConfig.getMaxSize()) {
            return;
        }
        cir.setReturnValue((Object)Stxck.isMergable(this.stxck$getThis()));
    }

    @Inject(method={"tryToMerge"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceTryToMerge(ItemEntity itemEntity1, CallbackInfo ci) {
        ItemEntity self = this.stxck$getThis();
        if (Stxck.isBlackListItem(self)) {
            return;
        }
        Stxck.tryToMerge(self, itemEntity1);
        ci.cancel();
    }

    @ModifyArg(method={"mergeWithNeighbours"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"), index=1)
    private AABB mergeWithNeighbours(AABB uwu) {
        double h = Stxck.commonConfig.getMaxMergeDistanceHorizontal();
        double v = Stxck.commonConfig.getMaxMergeDistanceVertical();
        return this.stxck$getThis().getBoundingBox().inflate(h, v, h);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")})
    private void saveExtraItemCount(CompoundTag compoundTag, CallbackInfo ci) {
        int extraCount = Stxck.getExtraItemCount(this.stxck$getThis());
        if (extraCount > 0) {
            compoundTag.putInt("StxckExtraItemCount", extraCount);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;getCompound(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundTag;")})
    private void readExtraItemCount(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains("StxckExtraItemCount")) {
            Stxck.setExtraItemCount(this.stxck$getThis(), compoundTag.getInt("StxckExtraItemCount"));
        }
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetEmpty(ItemStack item, CallbackInfo ci) {
        if (this.discardedTick) {
            ci.cancel();
            return;
        }
        if (item != ItemStack.EMPTY && !item.is(Items.AIR)) {
            return;
        }
        ItemEntity self = this.stxck$getThis();
        if (Stxck.getExtraItemCount(self) <= 0) {
            return;
        }
        ItemStack copied = self.getItem().copy();
        if (!copied.isEmpty()) {
            self.setItem(copied);
            copied.setCount(0);
        }
        ci.cancel();
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelPlayerTouchOnDiscard(Player player, CallbackInfo ci) {
        if (this.discardedTick) {
            ci.cancel();
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;onItemPickup(Lnet/minecraft/world/entity/item/ItemEntity;)V ")})
    private void syncItemOnPickup(Player player, CallbackInfo ci) {
        ItemEntity self = this.stxck$getThis();
        ItemStack item = self.getItem();
        if (!item.isEmpty()) {
            self.setItem(item.copy());
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (Stxck.tryRefillItemStackOnEntityRemove((Entity)this.stxck$getThis(), reason)) {
            this.discardedTick = true;
            this.unsetRemoved();
            return;
        }
        super.remove(reason);
    }

    @Unique
    private ItemEntity stxck$getThis() {
        return (ItemEntity)this;
    }

    static {
        Stxck.setDataExtraItemCount(STXCK_DATA_EXTRA_ITEM_COUNT);
    }
}

