/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.stateobserver.api;

import net.favouriteless.stateobserver.StateChangeSetImpl;
import net.favouriteless.stateobserver.api.StateChangeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class StateObserver {
    private final StateChangeSet changeSet = new StateChangeSetImpl();
    private final Level level;
    private final BlockPos pos;
    private final int radiusX;
    private final int radiusY;
    private final int radiusZ;

    public StateObserver(Level level, BlockPos pos, int radiusX, int radiusY, int radiusZ) {
        this.level = level;
        this.pos = pos;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        if (radiusX <= 0) {
            throw new IllegalStateException("StateObserver's X radius must be greater than Zero");
        }
        if (radiusY <= 0) {
            throw new IllegalStateException("StateObserver's Y radius must be greater than Zero");
        }
        if (radiusZ <= 0) {
            throw new IllegalStateException("StateObserver's Z radius must be greater than Zero");
        }
    }

    protected abstract void handleChanges();

    public abstract void onInit();

    public abstract void onRemove();

    public void checkChanges() {
        if (!this.changeSet.getChanges().isEmpty()) {
            this.handleChanges();
            this.changeSet.clear();
        }
    }

    public StateChangeSet getChangeSet() {
        return this.changeSet;
    }

    public boolean isWithinBounds(BlockPos pos) {
        return pos.getX() >= this.pos.getX() - this.radiusX && pos.getX() <= this.pos.getX() + this.radiusX && pos.getY() >= this.pos.getY() - this.radiusY && pos.getY() <= this.pos.getY() + this.radiusY && pos.getZ() >= this.pos.getZ() - this.radiusZ && pos.getZ() <= this.pos.getZ() + this.radiusZ;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }
}

