/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.neoforge;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.BambooSpikesBehavior;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.BlackboardDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.ClockDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.FluidFillLevelDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.GlobeDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.HourglassBehavior;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.ItemDisplayDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.NoticeBoardDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.NoticeBoardDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.PresentRecipientAttribute;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.SpeakerBlockDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.neoforge.create.TextHolderDisplayTarget;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public class CreateCompatImpl {
    public static final Supplier<ItemAttributeType> PRESENT_ATTRIBUTE = RegHelper.register((ResourceLocation)Supplementaries.res("present_recipient"), PresentRecipientAttribute.Type::new, (ResourceKey)CreateRegistries.ITEM_ATTRIBUTE_TYPE);

    public static void init() {
    }

    public static void setup() {
        try {
            MovementBehaviour.REGISTRY.register((Object)ModRegistry.BAMBOO_SPIKES.get(), (Object)new BambooSpikesBehavior());
            MovementBehaviour.REGISTRY.register((Object)ModRegistry.HOURGLASS.get(), (Object)new HourglassBehavior());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to register supplementaries create behaviors: {}", (Object)String.valueOf(e));
        }
    }

    public static void setupClient() {
    }

    public static boolean isContraption(MovementContext context, Entity passenger) {
        return false;
    }

    public static Rotation isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3((Vec3i)dir.getNormal());
        Vec3 v2 = (Vec3)rot.apply(v);
        double dot = v2.dot(new Vec3(0.0, 1.0, 0.0));
        if (dot > 0.0) {
            return Rotation.CLOCKWISE_90;
        }
        if (dot < 0.0) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public static ItemStack getDisplayedItem(DisplayLinkContext context, BlockEntity source, Predicate<ItemStack> predicate) {
        if (source instanceof ItemDisplayTile) {
            ItemDisplayTile display = (ItemDisplayTile)source;
            ItemStack stack = display.getDisplayedItem();
            if (predicate.test(stack)) {
                return stack;
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                BlockPos pos = context.getSourcePos();
                TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)context.level(), (BlockPos)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour == null) break;
                MutableObject stackHolder = new MutableObject();
                behaviour.handleCenteredProcessingOnAllItems(0.25f, tis -> {
                    stackHolder.setValue((Object)tis.stack);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
                ItemStack stack = (ItemStack)stackHolder.getValue();
                if (stack == null || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static void changeState(MovementContext context, BlockState newState) {
        Map blocks = context.contraption.getBlocks();
        if (blocks.containsKey(context.localPos)) {
            context.state = newState;
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)blocks.get(context.localPos);
            StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt());
            blocks.replace(context.localPos, newInfo);
        }
    }

    static {
        RegHelper.register((ResourceLocation)Supplementaries.res("notice_board_display_target"), () -> {
            NoticeBoardDisplayTarget obj = new NoticeBoardDisplayTarget();
            DisplayTarget.BY_BLOCK_ENTITY.register(ModRegistry.NOTICE_BOARD_TILE.get(), (Object)obj);
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_TARGET);
        RegHelper.register((ResourceLocation)Supplementaries.res("text_holder_display_target"), () -> {
            TextHolderDisplayTarget obj = new TextHolderDisplayTarget();
            DisplayTarget.BY_BLOCK_ENTITY.register(ModRegistry.WAY_SIGN_TILE.get(), (Object)obj);
            DisplayTarget.BY_BLOCK_ENTITY.register(ModRegistry.DOORMAT_TILE.get(), (Object)obj);
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_TARGET);
        RegHelper.register((ResourceLocation)Supplementaries.res("speaker_block_display_target"), () -> {
            SpeakerBlockDisplayTarget obj = new SpeakerBlockDisplayTarget();
            DisplayTarget.BY_BLOCK_ENTITY.register(ModRegistry.SPEAKER_BLOCK_TILE.get(), (Object)obj);
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_TARGET);
        RegHelper.register((ResourceLocation)Supplementaries.res("blackboard_display_target"), () -> {
            BlackboardDisplayTarget obj = new BlackboardDisplayTarget();
            DisplayTarget.BY_BLOCK_ENTITY.register(ModRegistry.BLACKBOARD_TILE.get(), (Object)obj);
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_TARGET);
        RegHelper.register((ResourceLocation)Supplementaries.res("globe_display_source"), () -> {
            GlobeDisplaySource obj = new GlobeDisplaySource();
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.GLOBE_TILE.get(), List.of(obj));
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_SOURCE);
        RegHelper.register((ResourceLocation)Supplementaries.res("notice_board_display_source"), () -> {
            NoticeBoardDisplaySource obj = new NoticeBoardDisplaySource();
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.NOTICE_BOARD_TILE.get(), List.of(obj));
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_SOURCE);
        RegHelper.register((ResourceLocation)Supplementaries.res("clock_source"), () -> {
            ClockDisplaySource obj = new ClockDisplaySource();
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.CLOCK_BLOCK_TILE.get(), List.of(obj));
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_SOURCE);
        RegHelper.register((ResourceLocation)Supplementaries.res("item_display_source"), () -> {
            ItemDisplayDisplaySource obj = new ItemDisplayDisplaySource();
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.PEDESTAL_TILE.get(), List.of(obj));
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.ITEM_SHELF_TILE.get(), List.of(obj));
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.STATUE_TILE.get(), List.of(obj));
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.HOURGLASS_TILE.get(), List.of(obj));
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_SOURCE);
        RegHelper.register((ResourceLocation)Supplementaries.res("fluid_tank_source"), () -> {
            FluidFillLevelDisplaySource obj = new FluidFillLevelDisplaySource();
            DisplaySource.BY_BLOCK_ENTITY.register(ModRegistry.JAR_TILE.get(), List.of(obj));
            return obj;
        }, (ResourceKey)CreateRegistries.DISPLAY_SOURCE);
    }
}

