/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.client.render.entity.renderer.layer;

import com.google.common.collect.ImmutableMap;
import com.izofar.takesapillage.common.ItTakesPillage;
import com.izofar.takesapillage.common.client.render.entity.model.ClayGolemModel;
import com.izofar.takesapillage.common.entity.ClayGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.LivingEntity;

public final class ClayGolemCrackinessLayer
extends RenderLayer<ClayGolem, ClayGolemModel> {
    private static final Map<Crackiness.Level, ResourceLocation> resourceLocations = ImmutableMap.of((Object)Crackiness.Level.LOW, (Object)ItTakesPillage.makeId("textures/entity/clay_golem/clay_golem_crackiness_low.png"), (Object)Crackiness.Level.MEDIUM, (Object)ItTakesPillage.makeId("textures/entity/clay_golem/clay_golem_crackiness_medium.png"), (Object)Crackiness.Level.HIGH, (Object)ItTakesPillage.makeId("textures/entity/clay_golem/clay_golem_crackiness_high.png"));

    public ClayGolemCrackinessLayer(RenderLayerParent<ClayGolem, ClayGolemModel> layer) {
        super(layer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ClayGolem clayGolem, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (clayGolem.isInvisible()) {
            return;
        }
        Crackiness.Level crackiness = clayGolem.getCrackiness();
        if (crackiness != Crackiness.Level.NONE) {
            ResourceLocation resourcelocation = resourceLocations.get(crackiness);
            ClayGolemCrackinessLayer.renderColoredCutoutModel((EntityModel)this.getParentModel(), (ResourceLocation)resourcelocation, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (LivingEntity)clayGolem, (int)-1);
        }
    }
}

